/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.common.entity.auth.Keys;
import io.github.pnoker.common.utils.DecodeUtil;
import io.github.pnoker.common.utils.TimeUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyUtil.class);

    private KeyUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Keys.Aes genAesKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES/GCM/NoPadding");
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        return new Keys.Aes(DecodeUtil.byteToString(DecodeUtil.encode(secretKey.getEncoded())));
    }

    public static String encryptAes(String content, String privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] keyBytes = DecodeUtil.decode(privateKey);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES/GCM/NoPadding");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, key);
        return DecodeUtil.byteToString(DecodeUtil.encode(cipher.doFinal(DecodeUtil.stringToByte(content))));
    }

    public static String decryptAes(String content, String privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] keyBytes = DecodeUtil.decode(privateKey);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES/GCM/NoPadding");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, key);
        byte[] inputByte = DecodeUtil.decode(DecodeUtil.stringToByte(content));
        return DecodeUtil.byteToString(cipher.doFinal(inputByte));
    }

    public static Keys.Rsa genRsaKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        keyPairGen.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = DecodeUtil.byteToString(DecodeUtil.encode(publicKey.getEncoded()));
        String privateKeyString = DecodeUtil.byteToString(DecodeUtil.encode(privateKey.getEncoded()));
        return new Keys.Rsa(publicKeyString, privateKeyString);
    }

    public static String encryptRsa(String content, String publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        byte[] keyBytes = DecodeUtil.decode(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING").generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        cipher.init(1, pubKey);
        return DecodeUtil.byteToString(DecodeUtil.encode(cipher.doFinal(DecodeUtil.stringToByte(content))));
    }

    public static String decryptRsa(String content, String privateKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        byte[] keyBytes = DecodeUtil.decode(privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING").generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        cipher.init(2, priKey);
        byte[] inputByte = DecodeUtil.decode(DecodeUtil.stringToByte(content));
        return DecodeUtil.byteToString(cipher.doFinal(inputByte));
    }

    public static String generateToken(String username, String salt, String tenantId) {
        JwtBuilder builder = Jwts.builder().setIssuer("io.github.pnoker.dc3/" + tenantId).setSubject(username).setIssuedAt(new Date()).signWith(SignatureAlgorithm.HS256, DecodeUtil.stringToByte(salt)).setExpiration(TimeUtil.expireTime(12, 10));
        return builder.compact();
    }

    public static Claims parserToken(String username, String salt, String token, String tenantId) {
        return (Claims)Jwts.parser().requireIssuer("io.github.pnoker.dc3/" + tenantId).requireSubject(username).setSigningKey(DecodeUtil.stringToByte(salt)).parseClaimsJws(token).getBody();
    }
}

