/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.pnoker.common.enums.ResponseEnum;
import java.io.Serializable;

public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean ok = false;
    private String code = ResponseEnum.OK.getCode();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String message = ResponseEnum.FAILURE.getMessage();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private T data;

    public static <T> R<T> ok() {
        return super.success();
    }

    public static <T> R<T> ok(String message) {
        return super.success(message);
    }

    public static <T> R<T> ok(ResponseEnum code, String message) {
        return super.success(code.getCode(), message);
    }

    public static <T> R<T> ok(T data) {
        return super.success();
    }

    public static <T> R<T> ok(T data, String message) {
        return super.success(message);
    }

    public static <T> R<T> fail() {
        return super.failure();
    }

    public static <T> R<T> fail(String message) {
        return super.failure(message);
    }

    public static <T> R<T> fail(ResponseEnum code, String message) {
        return super.failure(code.getCode(), message);
    }

    public static <T> R<T> fail(T data) {
        return super.failure();
    }

    public static <T> R<T> fail(T data, String message) {
        return super.failure(message);
    }

    private R(T data) {
        this.data = data;
    }

    private R<T> success() {
        this.ok = true;
        this.code = ResponseEnum.OK.getCode();
        this.message = ResponseEnum.OK.getMessage();
        return this;
    }

    private R<T> success(String message) {
        this.ok = true;
        this.code = ResponseEnum.OK.getCode();
        this.message = message;
        return this;
    }

    private R<T> success(String code, String message) {
        this.ok = true;
        this.code = code;
        this.message = message;
        return this;
    }

    private R<T> failure() {
        this.ok = false;
        this.code = ResponseEnum.FAILURE.getCode();
        this.message = ResponseEnum.FAILURE.getMessage();
        return this;
    }

    private R<T> failure(String message) {
        this.ok = false;
        this.code = ResponseEnum.FAILURE.getCode();
        this.message = message;
        return this;
    }

    private R<T> failure(String code, String message) {
        this.ok = false;
        this.code = code;
        this.message = message;
        return this;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "R(ok=" + this.isOk() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public R() {
    }

    public R(boolean ok, String code, String message, T data) {
        this.ok = ok;
        this.code = code;
        this.message = message;
        this.data = data;
    }
}

