/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.pnoker.common.entity.base.Base;
import io.github.pnoker.common.enums.EnableFlagEnum;
import io.github.pnoker.common.enums.PointTypeFlagEnum;
import io.github.pnoker.common.enums.RwFlagEnum;
import io.github.pnoker.common.valid.Insert;
import io.github.pnoker.common.valid.Update;
import java.math.BigDecimal;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@TableName(value="dc3_point")
public class Point
extends Base {
    @NotBlank(message="Point name can't be empty", groups={Insert.class})
    @Pattern(regexp="^[A-Za-z0-9\\u4e00-\\u9fa5][A-Za-z0-9\\u4e00-\\u9fa5-_#@/.|]{1,31}$", message="Invalid point name", groups={Insert.class, Update.class})
    private @NotBlank(message="Point name can't be empty", groups={Insert.class}) @Pattern(regexp="^[A-Za-z0-9\\u4e00-\\u9fa5][A-Za-z0-9\\u4e00-\\u9fa5-_#@/.|]{1,31}$", message="Invalid point name", groups={Insert.class, Update.class}) String pointName;
    private String pointCode;
    private PointTypeFlagEnum pointTypeFlag;
    private RwFlagEnum rwFlag;
    private BigDecimal baseValue;
    private BigDecimal multiple;
    private Byte valueDecimal;
    private String unit;
    @NotBlank(message="Profile id can't be empty", groups={Insert.class, Update.class})
    private @NotBlank(message="Profile id can't be empty", groups={Insert.class, Update.class}) String profileId;
    private String groupId;
    private EnableFlagEnum enableFlag;
    private String tenantId;

    public void setDefault() {
        this.pointTypeFlag = PointTypeFlagEnum.STRING;
        this.rwFlag = RwFlagEnum.R;
        this.baseValue = BigDecimal.valueOf(0L);
        this.multiple = BigDecimal.valueOf(1L);
        this.valueDecimal = 6;
        this.unit = "";
    }

    public String getPointName() {
        return this.pointName;
    }

    public String getPointCode() {
        return this.pointCode;
    }

    public PointTypeFlagEnum getPointTypeFlag() {
        return this.pointTypeFlag;
    }

    public RwFlagEnum getRwFlag() {
        return this.rwFlag;
    }

    public BigDecimal getBaseValue() {
        return this.baseValue;
    }

    public BigDecimal getMultiple() {
        return this.multiple;
    }

    public Byte getValueDecimal() {
        return this.valueDecimal;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public EnableFlagEnum getEnableFlag() {
        return this.enableFlag;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setPointName(String pointName) {
        this.pointName = pointName;
    }

    public void setPointCode(String pointCode) {
        this.pointCode = pointCode;
    }

    public void setPointTypeFlag(PointTypeFlagEnum pointTypeFlag) {
        this.pointTypeFlag = pointTypeFlag;
    }

    public void setRwFlag(RwFlagEnum rwFlag) {
        this.rwFlag = rwFlag;
    }

    public void setBaseValue(BigDecimal baseValue) {
        this.baseValue = baseValue;
    }

    public void setMultiple(BigDecimal multiple) {
        this.multiple = multiple;
    }

    public void setValueDecimal(Byte valueDecimal) {
        this.valueDecimal = valueDecimal;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setEnableFlag(EnableFlagEnum enableFlag) {
        this.enableFlag = enableFlag;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Point() {
    }

    public Point(String pointName, String pointCode, PointTypeFlagEnum pointTypeFlag, RwFlagEnum rwFlag, BigDecimal baseValue, BigDecimal multiple, Byte valueDecimal, String unit, String profileId, String groupId, EnableFlagEnum enableFlag, String tenantId) {
        this.pointName = pointName;
        this.pointCode = pointCode;
        this.pointTypeFlag = pointTypeFlag;
        this.rwFlag = rwFlag;
        this.baseValue = baseValue;
        this.multiple = multiple;
        this.valueDecimal = valueDecimal;
        this.unit = unit;
        this.profileId = profileId;
        this.groupId = groupId;
        this.enableFlag = enableFlag;
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return "Point(super=" + super.toString() + ", pointName=" + this.getPointName() + ", pointCode=" + this.getPointCode() + ", pointTypeFlag=" + this.getPointTypeFlag() + ", rwFlag=" + this.getRwFlag() + ", baseValue=" + this.getBaseValue() + ", multiple=" + this.getMultiple() + ", valueDecimal=" + this.getValueDecimal() + ", unit=" + this.getUnit() + ", profileId=" + this.getProfileId() + ", groupId=" + this.getGroupId() + ", enableFlag=" + this.getEnableFlag() + ", tenantId=" + this.getTenantId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Byte this$valueDecimal = this.getValueDecimal();
        Byte other$valueDecimal = other.getValueDecimal();
        if (this$valueDecimal == null ? other$valueDecimal != null : !((Object)this$valueDecimal).equals(other$valueDecimal)) {
            return false;
        }
        String this$pointName = this.getPointName();
        String other$pointName = other.getPointName();
        if (this$pointName == null ? other$pointName != null : !this$pointName.equals(other$pointName)) {
            return false;
        }
        String this$pointCode = this.getPointCode();
        String other$pointCode = other.getPointCode();
        if (this$pointCode == null ? other$pointCode != null : !this$pointCode.equals(other$pointCode)) {
            return false;
        }
        PointTypeFlagEnum this$pointTypeFlag = this.getPointTypeFlag();
        PointTypeFlagEnum other$pointTypeFlag = other.getPointTypeFlag();
        if (this$pointTypeFlag == null ? other$pointTypeFlag != null : !this$pointTypeFlag.equals(other$pointTypeFlag)) {
            return false;
        }
        RwFlagEnum this$rwFlag = this.getRwFlag();
        RwFlagEnum other$rwFlag = other.getRwFlag();
        if (this$rwFlag == null ? other$rwFlag != null : !this$rwFlag.equals(other$rwFlag)) {
            return false;
        }
        BigDecimal this$baseValue = this.getBaseValue();
        BigDecimal other$baseValue = other.getBaseValue();
        if (this$baseValue == null ? other$baseValue != null : !((Object)this$baseValue).equals(other$baseValue)) {
            return false;
        }
        BigDecimal this$multiple = this.getMultiple();
        BigDecimal other$multiple = other.getMultiple();
        if (this$multiple == null ? other$multiple != null : !((Object)this$multiple).equals(other$multiple)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$profileId = this.getProfileId();
        String other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !this$profileId.equals(other$profileId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        EnableFlagEnum this$enableFlag = this.getEnableFlag();
        EnableFlagEnum other$enableFlag = other.getEnableFlag();
        if (this$enableFlag == null ? other$enableFlag != null : !this$enableFlag.equals(other$enableFlag)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Byte $valueDecimal = this.getValueDecimal();
        result = result * 59 + ($valueDecimal == null ? 43 : ((Object)$valueDecimal).hashCode());
        String $pointName = this.getPointName();
        result = result * 59 + ($pointName == null ? 43 : $pointName.hashCode());
        String $pointCode = this.getPointCode();
        result = result * 59 + ($pointCode == null ? 43 : $pointCode.hashCode());
        PointTypeFlagEnum $pointTypeFlag = this.getPointTypeFlag();
        result = result * 59 + ($pointTypeFlag == null ? 43 : $pointTypeFlag.hashCode());
        RwFlagEnum $rwFlag = this.getRwFlag();
        result = result * 59 + ($rwFlag == null ? 43 : $rwFlag.hashCode());
        BigDecimal $baseValue = this.getBaseValue();
        result = result * 59 + ($baseValue == null ? 43 : ((Object)$baseValue).hashCode());
        BigDecimal $multiple = this.getMultiple();
        result = result * 59 + ($multiple == null ? 43 : ((Object)$multiple).hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : $profileId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        EnableFlagEnum $enableFlag = this.getEnableFlag();
        result = result * 59 + ($enableFlag == null ? 43 : $enableFlag.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }
}

