/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity.point;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PointValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String deviceId;
    private String pointId;
    private String value;
    private String rawValue;
    private List<String> children;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    private Date originTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    private Date createTime;

    public PointValue(String deviceId, String pointId, String rawValue, String value) {
        this.deviceId = deviceId;
        this.pointId = pointId;
        this.rawValue = rawValue;
        this.value = value;
        this.originTime = new Date();
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getPointId() {
        return this.pointId;
    }

    public String getValue() {
        return this.value;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public List<String> getChildren() {
        return this.children;
    }

    public Date getOriginTime() {
        return this.originTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setPointId(String pointId) {
        this.pointId = pointId;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public void setChildren(List<String> children) {
        this.children = children;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    public void setOriginTime(Date originTime) {
        this.originTime = originTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PointValue)) {
            return false;
        }
        PointValue other = (PointValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$pointId = this.getPointId();
        String other$pointId = other.getPointId();
        if (this$pointId == null ? other$pointId != null : !this$pointId.equals(other$pointId)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$rawValue = this.getRawValue();
        String other$rawValue = other.getRawValue();
        if (this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue)) {
            return false;
        }
        List<String> this$children = this.getChildren();
        List<String> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        Date this$originTime = this.getOriginTime();
        Date other$originTime = other.getOriginTime();
        if (this$originTime == null ? other$originTime != null : !((Object)this$originTime).equals(other$originTime)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PointValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $pointId = this.getPointId();
        result = result * 59 + ($pointId == null ? 43 : $pointId.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $rawValue = this.getRawValue();
        result = result * 59 + ($rawValue == null ? 43 : $rawValue.hashCode());
        List<String> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        Date $originTime = this.getOriginTime();
        result = result * 59 + ($originTime == null ? 43 : ((Object)$originTime).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "PointValue(id=" + this.getId() + ", deviceId=" + this.getDeviceId() + ", pointId=" + this.getPointId() + ", value=" + this.getValue() + ", rawValue=" + this.getRawValue() + ", children=" + this.getChildren() + ", originTime=" + this.getOriginTime() + ", createTime=" + this.getCreateTime() + ")";
    }

    public PointValue() {
    }

    public PointValue(String id, String deviceId, String pointId, String value, String rawValue, List<String> children, Date originTime, Date createTime) {
        this.id = id;
        this.deviceId = deviceId;
        this.pointId = pointId;
        this.value = value;
        this.rawValue = rawValue;
        this.children = children;
        this.originTime = originTime;
        this.createTime = createTime;
    }
}

