/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity.point;

import com.influxdb.annotations.Column;
import com.influxdb.annotations.Measurement;
import io.github.pnoker.common.entity.point.PointValue;
import java.time.Instant;

@Measurement(name="point_value")
public class InfluxPoint {
    @Column(tag=true)
    private String deviceId;
    @Column(tag=true)
    private String pointId;
    @Column
    private String pointValue;
    @Column(timestamp=true)
    private Instant time;

    public InfluxPoint(PointValue pointValue) {
        this.deviceId = pointValue.getDeviceId();
        this.pointId = pointValue.getPointId();
        this.pointValue = pointValue.getValue();
        this.time = pointValue.getCreateTime().toInstant();
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getPointId() {
        return this.pointId;
    }

    public String getPointValue() {
        return this.pointValue;
    }

    public Instant getTime() {
        return this.time;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setPointId(String pointId) {
        this.pointId = pointId;
    }

    public void setPointValue(String pointValue) {
        this.pointValue = pointValue;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxPoint)) {
            return false;
        }
        InfluxPoint other = (InfluxPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$pointId = this.getPointId();
        String other$pointId = other.getPointId();
        if (this$pointId == null ? other$pointId != null : !this$pointId.equals(other$pointId)) {
            return false;
        }
        String this$pointValue = this.getPointValue();
        String other$pointValue = other.getPointValue();
        if (this$pointValue == null ? other$pointValue != null : !this$pointValue.equals(other$pointValue)) {
            return false;
        }
        Instant this$time = this.getTime();
        Instant other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $pointId = this.getPointId();
        result = result * 59 + ($pointId == null ? 43 : $pointId.hashCode());
        String $pointValue = this.getPointValue();
        result = result * 59 + ($pointValue == null ? 43 : $pointValue.hashCode());
        Instant $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public String toString() {
        return "InfluxPoint(deviceId=" + this.getDeviceId() + ", pointId=" + this.getPointId() + ", pointValue=" + this.getPointValue() + ", time=" + this.getTime() + ")";
    }
}

