/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoId;

@Document
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @MongoId
    private ObjectId id;
    private String deviceId;
    private String pointId;
    private String type;
    private Boolean confirm = false;
    private Object content;
    @Transient
    private int timeOut = 15;
    @Transient
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    private Long originTime;
    private Long confirmTime;

    public DeviceEvent(String deviceId, String type, Object content) {
        this.deviceId = deviceId;
        this.type = type;
        this.content = content;
        this.originTime = System.currentTimeMillis();
    }

    public DeviceEvent(String deviceId, String type, Object content, int timeOut, TimeUnit timeUnit) {
        this.deviceId = deviceId;
        this.type = type;
        this.content = content;
        this.timeOut = timeOut;
        this.timeUnit = timeUnit;
        this.originTime = System.currentTimeMillis();
    }

    public DeviceEvent(String deviceId, String pointId, String type, Object content) {
        this.deviceId = deviceId;
        this.pointId = pointId;
        this.type = type;
        this.content = content;
        this.originTime = System.currentTimeMillis();
    }

    public DeviceEvent(String deviceId, String pointId, String type, Object content, int timeOut, TimeUnit timeUnit) {
        this.deviceId = deviceId;
        this.pointId = pointId;
        this.type = type;
        this.content = content;
        this.timeOut = timeOut;
        this.timeUnit = timeUnit;
        this.originTime = System.currentTimeMillis();
    }

    public ObjectId getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getPointId() {
        return this.pointId;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getConfirm() {
        return this.confirm;
    }

    public Object getContent() {
        return this.content;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getOriginTime() {
        return this.originTime;
    }

    public Long getConfirmTime() {
        return this.confirmTime;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setPointId(String pointId) {
        this.pointId = pointId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setConfirm(Boolean confirm) {
        this.confirm = confirm;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setOriginTime(Long originTime) {
        this.originTime = originTime;
    }

    public void setConfirmTime(Long confirmTime) {
        this.confirmTime = confirmTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceEvent)) {
            return false;
        }
        DeviceEvent other = (DeviceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeOut() != other.getTimeOut()) {
            return false;
        }
        Boolean this$confirm = this.getConfirm();
        Boolean other$confirm = other.getConfirm();
        if (this$confirm == null ? other$confirm != null : !((Object)this$confirm).equals(other$confirm)) {
            return false;
        }
        Long this$originTime = this.getOriginTime();
        Long other$originTime = other.getOriginTime();
        if (this$originTime == null ? other$originTime != null : !((Object)this$originTime).equals(other$originTime)) {
            return false;
        }
        Long this$confirmTime = this.getConfirmTime();
        Long other$confirmTime = other.getConfirmTime();
        if (this$confirmTime == null ? other$confirmTime != null : !((Object)this$confirmTime).equals(other$confirmTime)) {
            return false;
        }
        ObjectId this$id = this.getId();
        ObjectId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$pointId = this.getPointId();
        String other$pointId = other.getPointId();
        if (this$pointId == null ? other$pointId != null : !this$pointId.equals(other$pointId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeOut();
        Boolean $confirm = this.getConfirm();
        result = result * 59 + ($confirm == null ? 43 : ((Object)$confirm).hashCode());
        Long $originTime = this.getOriginTime();
        result = result * 59 + ($originTime == null ? 43 : ((Object)$originTime).hashCode());
        Long $confirmTime = this.getConfirmTime();
        result = result * 59 + ($confirmTime == null ? 43 : ((Object)$confirmTime).hashCode());
        ObjectId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $pointId = this.getPointId();
        result = result * 59 + ($pointId == null ? 43 : $pointId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceEvent(id=" + this.getId() + ", deviceId=" + this.getDeviceId() + ", pointId=" + this.getPointId() + ", type=" + this.getType() + ", confirm=" + this.getConfirm() + ", content=" + this.getContent() + ", timeOut=" + this.getTimeOut() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", originTime=" + this.getOriginTime() + ", confirmTime=" + this.getConfirmTime() + ")";
    }

    public DeviceEvent() {
    }

    public DeviceEvent(ObjectId id, String deviceId, String pointId, String type, Boolean confirm, Object content, int timeOut, TimeUnit timeUnit, Long originTime, Long confirmTime) {
        this.id = id;
        this.deviceId = deviceId;
        this.pointId = pointId;
        this.type = type;
        this.confirm = confirm;
        this.content = content;
        this.timeOut = timeOut;
        this.timeUnit = timeUnit;
        this.originTime = originTime;
        this.confirmTime = confirmTime;
    }
}

