/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.domain.IsOnboarding;
import com.influxdb.client.domain.OnboardingRequest;
import com.influxdb.client.domain.OnboardingResponse;
import com.influxdb.client.service.SetupService;
import io.github.pnoker.common.property.InfluxProperties;
import java.io.IOException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.Response;

@Configuration
@EnableConfigurationProperties(value={InfluxProperties.class})
public class InfluxConfig {
    private static final Logger log = LoggerFactory.getLogger(InfluxConfig.class);
    @Autowired
    InfluxProperties properties;

    @Bean
    public InfluxDBClient influxDBClient() throws IOException {
        String zapTraceSpan;
        InfluxDBClient influxDBClient;
        SetupService setupService;
        Response response;
        if ((this.properties.getToken() == null || this.properties.getToken().isEmpty()) && (response = (setupService = (SetupService)(influxDBClient = InfluxDBClientFactory.create((String)this.properties.getUrl())).getService(SetupService.class)).getSetup(zapTraceSpan = Instant.now().toString()).execute()).isSuccessful() && response.body() != null && ((IsOnboarding)response.body()).getAllowed().booleanValue()) {
            OnboardingRequest onboardingRequest = new OnboardingRequest();
            onboardingRequest.setUsername(this.properties.getUsername());
            onboardingRequest.setOrg(this.properties.getOrganization());
            onboardingRequest.setBucket(this.properties.getBucket());
            onboardingRequest.setPassword(this.properties.getPassword());
            Response onBoardingResponse = setupService.postSetup(onboardingRequest, zapTraceSpan).execute();
            OnboardingResponse onboardingResponse = (OnboardingResponse)onBoardingResponse.body();
            log.info("influx setup:token{}", (Object)onboardingResponse.getAuth().getToken());
            return InfluxDBClientFactory.create((String)this.properties.getUrl(), (char[])onboardingResponse.getAuth().getToken().toCharArray(), (String)this.properties.getOrganization(), (String)this.properties.getBucket());
        }
        return InfluxDBClientFactory.create((String)this.properties.getUrl(), (char[])this.properties.getToken().toCharArray(), (String)this.properties.getOrganization(), (String)this.properties.getBucket());
    }
}

