/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.file;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchFileCenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchFileCenter.class);
    private static final int MAX_WATCH_FILE_JOB = Integer.getInteger("nacos.watch-file.max-dirs", 16);
    private static final Map<String, WatchDirJob> MANAGER = new HashMap<String, WatchDirJob>(MAX_WATCH_FILE_JOB);
    private static final FileSystem FILE_SYSTEM = FileSystems.getDefault();
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private static int NOW_WATCH_JOB_CNT;

    public static synchronized boolean registerWatcher(String paths, FileWatcher watcher) throws NacosException {
        WatchFileCenter.checkState();
        if (NOW_WATCH_JOB_CNT == MAX_WATCH_FILE_JOB) {
            return false;
        }
        WatchDirJob job = MANAGER.get(paths);
        if (job == null) {
            job = new WatchDirJob(paths);
            job.start();
            MANAGER.put(paths, job);
            ++NOW_WATCH_JOB_CNT;
        }
        job.addSubscribe(watcher);
        return true;
    }

    public static synchronized boolean deregisterAllWatcher(String path) {
        WatchDirJob job = MANAGER.get(path);
        if (job != null) {
            job.shutdown();
            MANAGER.remove(path);
            --NOW_WATCH_JOB_CNT;
            return true;
        }
        return false;
    }

    public static void shutdown() {
        if (!CLOSED.compareAndSet(false, true)) {
            return;
        }
        LOGGER.warn("[WatchFileCenter] start close");
        for (Map.Entry<String, WatchDirJob> entry : MANAGER.entrySet()) {
            LOGGER.warn("[WatchFileCenter] start to shutdown this watcher which is watch : " + entry.getKey());
            try {
                entry.getValue().shutdown();
            }
            catch (Throwable e) {
                LOGGER.error("[WatchFileCenter] shutdown has error : ", e);
            }
        }
        MANAGER.clear();
        NOW_WATCH_JOB_CNT = 0;
        LOGGER.warn("[WatchFileCenter] already closed");
    }

    public static synchronized boolean deregisterWatcher(String path, FileWatcher watcher) {
        WatchDirJob job = MANAGER.get(path);
        if (job != null) {
            job.watchers.remove(watcher);
            return true;
        }
        return false;
    }

    private static void checkState() {
        if (CLOSED.get()) {
            throw new IllegalStateException("WatchFileCenter already shutdown");
        }
    }

    static {
        ThreadUtils.addShutdownHook(WatchFileCenter::shutdown);
        NOW_WATCH_JOB_CNT = 0;
    }

    static class WatchDirJob
    extends Thread {
        private final ExecutorService callBackExecutor;
        private final String paths;
        private final WatchService watchService;
        private volatile boolean watch = true;
        private final Set<FileWatcher> watchers = new ConcurrentHashSet();

        public WatchDirJob(String paths) throws NacosException {
            this.setDaemon(true);
            this.setName(paths);
            this.paths = paths;
            Path p = Paths.get(paths, new String[0]);
            if (!p.toFile().isDirectory()) {
                throw new IllegalArgumentException("Must be a file directory : " + paths);
            }
            this.callBackExecutor = ExecutorFactory.newSingleExecutorService((ThreadFactory)new NameThreadFactory("com.alibaba.nacos.sys.file.watch-" + paths));
            try {
                WatchService service = FILE_SYSTEM.newWatchService();
                p.register(service, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                this.watchService = service;
            }
            catch (Throwable ex) {
                throw new NacosException(500, ex);
            }
        }

        void addSubscribe(FileWatcher watcher) {
            this.watchers.add(watcher);
        }

        void shutdown() {
            this.watch = false;
            try {
                this.watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ThreadUtils.shutdownThreadPool((ExecutorService)this.callBackExecutor);
        }

        @Override
        public void run() {
            while (this.watch && !this.isInterrupted()) {
                try {
                    WatchKey watchKey = this.watchService.take();
                    List<WatchEvent<?>> events = watchKey.pollEvents();
                    watchKey.reset();
                    if (this.callBackExecutor.isShutdown()) {
                        return;
                    }
                    if (events.isEmpty()) continue;
                    this.callBackExecutor.execute(() -> {
                        for (WatchEvent event : events) {
                            WatchEvent.Kind kind = event.kind();
                            if (StandardWatchEventKinds.OVERFLOW.equals(kind)) {
                                this.eventOverflow();
                                continue;
                            }
                            this.eventProcess(event.context());
                        }
                    });
                }
                catch (InterruptedException | ClosedWatchServiceException ignore) {
                    Thread.interrupted();
                }
                catch (Throwable ex) {
                    LOGGER.error("An exception occurred during file listening : ", ex);
                }
            }
        }

        private void eventProcess(Object context) {
            FileChangeEvent fileChangeEvent = FileChangeEvent.builder().paths(this.paths).context(context).build();
            String str = String.valueOf(context);
            for (FileWatcher watcher : this.watchers) {
                if (!watcher.interest(str)) continue;
                Runnable job = () -> watcher.onChange(fileChangeEvent);
                Executor executor = watcher.executor();
                if (executor == null) {
                    try {
                        job.run();
                    }
                    catch (Throwable ex) {
                        LOGGER.error("File change event callback error : ", ex);
                    }
                    continue;
                }
                executor.execute(job);
            }
        }

        private void eventOverflow() {
            File dir = Paths.get(this.paths, new String[0]).toFile();
            for (File file : Objects.requireNonNull(dir.listFiles())) {
                if (file.isDirectory()) continue;
                this.eventProcess(file.getName());
            }
        }
    }
}

