/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.prometheus.conf;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.web.NacosWebBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@NacosWebBean
@ConditionalOnProperty(name={"nacos.prometheus.metrics.enabled"}, havingValue="true")
public class PrometheusSecurityConfiguration {
    @Bean
    @Conditional(value={ConditionOnNoAuthPluginType.class})
    public SecurityFilterChain prometheusSecurityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(new String[]{"/prometheus", "/prometheus/namespaceId/{namespaceId}", "/prometheus/namespaceId/{namespaceId}/service/{service}"})).permitAll());
        return (SecurityFilterChain)http.getOrBuild();
    }

    private static class ConditionOnNoAuthPluginType
    implements Condition {
        private ConditionOnNoAuthPluginType() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String nacosAuthSystemType = context.getEnvironment().getProperty("nacos.core.auth.system.type", "");
            return StringUtils.isBlank((CharSequence)nacosAuthSystemType);
        }
    }
}

