/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.web.NacosWebBean;
import com.alibaba.nacos.naming.web.ClientAttributesFilter;
import com.alibaba.nacos.naming.web.DistroFilter;
import com.alibaba.nacos.naming.web.ServiceNameFilter;
import com.alibaba.nacos.naming.web.TrafficReviseFilter;
import jakarta.servlet.Filter;
import javax.annotation.PostConstruct;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@NacosWebBean
public class NamingConfig {
    private static final String URL_PATTERNS = "/v1/ns/*";
    private static final String URL_PATTERNS_V2 = "/v2/ns/*";
    private static final String DISTRO_FILTER = "distroFilter";
    private static final String SERVICE_NAME_FILTER = "serviceNameFilter";
    private static final String TRAFFIC_REVISE_FILTER = "trafficReviseFilter";
    private static final String CLIENT_ATTRIBUTES_FILTER = "clientAttributes_filter";
    private final ControllerMethodsCache methodsCache;

    public NamingConfig(ControllerMethodsCache methodsCache) {
        this.methodsCache = methodsCache;
    }

    @PostConstruct
    public void init() {
        this.methodsCache.initClassMethod("com.alibaba.nacos.naming.controllers");
    }

    @Bean
    public FilterRegistrationBean<DistroFilter> distroFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.distroFilter());
        registration.addUrlPatterns(new String[]{URL_PATTERNS});
        registration.setName(DISTRO_FILTER);
        registration.setOrder(7);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<ServiceNameFilter> serviceNameFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.serviceNameFilter());
        registration.addUrlPatterns(new String[]{URL_PATTERNS});
        registration.setName(SERVICE_NAME_FILTER);
        registration.setOrder(5);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<TrafficReviseFilter> trafficReviseFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.trafficReviseFilter());
        registration.addUrlPatterns(new String[]{URL_PATTERNS});
        registration.setName(TRAFFIC_REVISE_FILTER);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<ClientAttributesFilter> clientAttributesFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.clientAttributesFilter());
        registration.addUrlPatterns(new String[]{URL_PATTERNS, URL_PATTERNS_V2});
        registration.setName(CLIENT_ATTRIBUTES_FILTER);
        registration.setOrder(8);
        return registration;
    }

    @Bean
    public DistroFilter distroFilter() {
        return new DistroFilter();
    }

    @Bean
    public TrafficReviseFilter trafficReviseFilter() {
        return new TrafficReviseFilter();
    }

    @Bean
    public ServiceNameFilter serviceNameFilter() {
        return new ServiceNameFilter();
    }

    @Bean
    public ClientAttributesFilter clientAttributesFilter() {
        return new ClientAttributesFilter();
    }
}

