/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.auth.util.AuthHeaderUtil;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.core.auth.NacosServerAuthConfig;
import com.alibaba.nacos.naming.misc.HttpClientManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HttpClient {
    private static final int TIME_OUT_MILLIS = 10000;
    private static final int CON_TIME_OUT_MILLIS = 5000;
    private static final NacosRestTemplate APACHE_SYNC_NACOS_REST_TEMPLATE = HttpClientManager.getApacheRestTemplate();
    private static final NacosAsyncRestTemplate ASYNC_REST_TEMPLATE = HttpClientManager.getAsyncRestTemplate();
    private static final String ENCODING = "UTF-8";
    private static final String NOFIX = "1";

    public static RestResult<String> httpDelete(String url, List<String> headers, Map<String, String> paramValues) {
        return HttpClient.request(url, headers, paramValues, "", 5000, 10000, ENCODING, "DELETE");
    }

    public static RestResult<String> httpGet(String url, List<String> headers, Map<String, String> paramValues) {
        return HttpClient.request(url, headers, paramValues, "", 5000, 10000, ENCODING, "GET");
    }

    public static RestResult<String> request(String url, List<String> headers, Map<String, String> paramValues, String body, int connectTimeout, int readTimeout, String encoding, String method) {
        Header header = Header.newInstance();
        if (CollectionUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        header.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        header.addParam("Client-Version", VersionUtils.version);
        header.addParam("User-Agent", UtilsAndCommons.SERVER_VERSION);
        header.addParam("Request-Source", EnvUtil.getLocalAddress());
        header.addParam("Accept-Charset", encoding);
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        HttpClientConfig httpClientConfig = HttpClientConfig.builder().setConTimeOutMillis(connectTimeout).setReadTimeOutMillis(readTimeout).build();
        Query query = Query.newInstance().initParams(paramValues);
        query.addParam("encoding", (Object)ENCODING);
        query.addParam("nofix", (Object)NOFIX);
        try {
            return APACHE_SYNC_NACOS_REST_TEMPLATE.exchange(url, httpClientConfig, header, query, (Object)body, method, String.class);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("Exception while request: {}, caused: {}", (Object)url, (Object)e);
            return RestResult.builder().withCode(500).withMsg(e.toString()).build();
        }
    }

    public static void asyncHttpGet(String url, List<String> headers, Map<String, String> paramValues, Callback<String> callback) throws Exception {
        HttpClient.asyncHttpRequest(url, headers, paramValues, callback, "GET");
    }

    public static void asyncHttpPost(String url, List<String> headers, Map<String, String> paramValues, Callback<String> callback) throws Exception {
        HttpClient.asyncHttpRequest(url, headers, paramValues, callback, "POST");
    }

    public static void asyncHttpDelete(String url, List<String> headers, Map<String, String> paramValues, Callback<String> callback) throws Exception {
        HttpClient.asyncHttpRequest(url, headers, paramValues, callback, "DELETE");
    }

    public static void asyncHttpRequest(String url, List<String> headers, Map<String, String> paramValues, Callback<String> callback, String method) throws Exception {
        Query query = Query.newInstance().initParams(paramValues);
        query.addParam("encoding", (Object)ENCODING);
        query.addParam("nofix", (Object)NOFIX);
        Header header = Header.newInstance();
        if (CollectionUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        header.addParam("Accept-Charset", ENCODING);
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        switch (method) {
            case "GET": {
                ASYNC_REST_TEMPLATE.get(url, header, query, String.class, callback);
                break;
            }
            case "POST": {
                ASYNC_REST_TEMPLATE.postForm(url, header, paramValues, String.class, callback);
                break;
            }
            case "PUT": {
                ASYNC_REST_TEMPLATE.putForm(url, header, paramValues, String.class, callback);
                break;
            }
            case "DELETE": {
                ASYNC_REST_TEMPLATE.delete(url, header, query, String.class, callback);
                break;
            }
            default: {
                throw new RuntimeException("not supported method:" + method);
            }
        }
    }

    public static void asyncHttpPostLarge(String url, List<String> headers, String content, Callback<String> callback) throws Exception {
        HttpClient.asyncHttpPostLarge(url, headers, content.getBytes(), callback);
    }

    public static void asyncHttpPostLarge(String url, List<String> headers, byte[] content, Callback<String> callback) throws Exception {
        Header header = Header.newInstance();
        if (CollectionUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        ASYNC_REST_TEMPLATE.post(url, header, Query.EMPTY, (Object)content, String.class, callback);
    }

    public static void asyncHttpDeleteLarge(String url, List<String> headers, String content, Callback<String> callback) throws Exception {
        Header header = Header.newInstance();
        if (CollectionUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        ASYNC_REST_TEMPLATE.delete(url, header, content, String.class, callback);
    }

    public static RestResult<String> httpPost(String url, List<String> headers, Map<String, String> paramValues) {
        return HttpClient.httpPost(url, headers, paramValues, ENCODING);
    }

    public static RestResult<String> httpPost(String url, List<String> headers, Map<String, String> paramValues, String encoding) {
        try {
            Header header = Header.newInstance();
            if (CollectionUtils.isNotEmpty(headers)) {
                header.addAll(headers);
            }
            header.addParam("Accept-Charset", encoding);
            AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
            HttpClientConfig httpClientConfig = HttpClientConfig.builder().setConTimeOutMillis(5000).setReadTimeOutMillis(5000).build();
            return APACHE_SYNC_NACOS_REST_TEMPLATE.postForm(url, httpClientConfig, header, paramValues, String.class);
        }
        catch (Throwable e) {
            return RestResult.builder().withCode(500).withMsg(e.toString()).build();
        }
    }

    public static void asyncHttpPutLarge(String url, Map<String, String> headers, byte[] content, Callback<String> callback) throws Exception {
        Header header = Header.newInstance();
        if (MapUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        ASYNC_REST_TEMPLATE.put(url, header, Query.EMPTY, (Object)content, String.class, callback);
    }

    public static RestResult<String> httpPutLarge(String url, Map<String, String> headers, byte[] content) {
        Header header = Header.newInstance();
        if (MapUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        try {
            return APACHE_SYNC_NACOS_REST_TEMPLATE.put(url, header, Query.EMPTY, (Object)content, String.class);
        }
        catch (Exception e) {
            return RestResult.builder().withCode(500).withMsg(e.toString()).build();
        }
    }

    public static RestResult<String> httpGetLarge(String url, Map<String, String> headers, String content) {
        Header header = Header.newInstance();
        if (MapUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        try {
            return APACHE_SYNC_NACOS_REST_TEMPLATE.getLarge(url, header, Query.EMPTY, (Object)content, String.class);
        }
        catch (Exception e) {
            return RestResult.builder().withCode(500).withMsg(e.toString()).build();
        }
    }

    public static RestResult<String> httpPostLarge(String url, Map<String, String> headers, String content) {
        Header header = Header.newInstance();
        if (MapUtils.isNotEmpty(headers)) {
            header.addAll(headers);
        }
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE));
        try {
            return APACHE_SYNC_NACOS_REST_TEMPLATE.postJson(url, header, content, String.class);
        }
        catch (Exception e) {
            return RestResult.builder().withCode(500).withMsg(e.toString()).build();
        }
    }

    public static Map<String, String> translateParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String key : parameterMap.keySet()) {
            map.put(key, parameterMap.get(key)[0]);
        }
        return map;
    }
}

