/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.event.client;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.Set;

public class ClientOperationEvent
extends Event {
    private static final long serialVersionUID = -4582413232902517619L;
    private final String clientId;
    private final Service service;

    public ClientOperationEvent(String clientId, Service service) {
        this.clientId = clientId;
        this.service = service;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Service getService() {
        return this.service;
    }

    public static class ClientReleaseEvent
    extends ClientOperationEvent {
        private static final long serialVersionUID = -281486927726245701L;
        private final Client client;
        private final boolean isNative;

        public ClientReleaseEvent(Client client, boolean isNative) {
            super(client.getClientId(), null);
            this.client = client;
            this.isNative = isNative;
        }

        public Client getClient() {
            return this.client;
        }

        public boolean isNative() {
            return this.isNative;
        }
    }

    public static class ClientFuzzyWatchEvent
    extends ClientOperationEvent {
        private static final long serialVersionUID = -4518919987813223119L;
        private final String groupKeyPattern;
        private Set<String> clientReceivedServiceKeys;
        private boolean isInitializing;

        public ClientFuzzyWatchEvent(String groupKeyPattern, String clientId, Set<String> clientReceivedServiceKeys, boolean isInitializing) {
            super(clientId, null);
            this.groupKeyPattern = groupKeyPattern;
            this.clientReceivedServiceKeys = clientReceivedServiceKeys;
            this.isInitializing = isInitializing;
        }

        public String getGroupKeyPattern() {
            return this.groupKeyPattern;
        }

        public Set<String> getClientReceivedServiceKeys() {
            return this.clientReceivedServiceKeys;
        }

        public boolean isInitializing() {
            return this.isInitializing;
        }
    }

    public static class ClientUnsubscribeServiceEvent
    extends ClientOperationEvent {
        private static final long serialVersionUID = -4518919987813223120L;

        public ClientUnsubscribeServiceEvent(Service service, String clientId) {
            super(clientId, service);
        }
    }

    public static class ClientSubscribeServiceEvent
    extends ClientOperationEvent {
        private static final long serialVersionUID = -4518919987813223120L;

        public ClientSubscribeServiceEvent(Service service, String clientId) {
            super(clientId, service);
        }
    }

    public static class ClientDeregisterServiceEvent
    extends ClientOperationEvent {
        private static final long serialVersionUID = -4518919987813223120L;

        public ClientDeregisterServiceEvent(Service service, String clientId) {
            super(clientId, service);
        }
    }

    public static class ClientRegisterServiceEvent
    extends ClientOperationEvent {
        private static final long serialVersionUID = 3412396514440368087L;

        public ClientRegisterServiceEvent(Service service, String clientId) {
            super(clientId, service);
        }
    }
}

