/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.naming.core.HealthOperator;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManagerDelegate;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationService;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationServiceProxy;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HealthOperatorV2Impl
implements HealthOperator {
    private final NamingMetadataManager metadataManager;
    private final ClientManager clientManager;
    private final ClientOperationService clientOperationService;

    public HealthOperatorV2Impl(NamingMetadataManager metadataManager, ClientManagerDelegate clientManager, ClientOperationServiceProxy clientOperationService) {
        this.metadataManager = metadataManager;
        this.clientManager = clientManager;
        this.clientOperationService = clientOperationService;
    }

    @Override
    public void updateHealthStatusForPersistentInstance(String namespace, String groupName, String serviceName, String clusterName, String ip, int port, boolean healthy) throws NacosException {
        String clientId;
        Client client;
        Service service = Service.newService(namespace, groupName, serviceName);
        Optional<ServiceMetadata> serviceMetadata = this.metadataManager.getServiceMetadata(service);
        if (serviceMetadata.isEmpty() || !serviceMetadata.get().getClusters().containsKey(clusterName)) {
            this.throwHealthCheckerException(groupName, serviceName, clusterName);
        }
        ClusterMetadata clusterMetadata = serviceMetadata.get().getClusters().get(clusterName);
        if (!HealthCheckType.NONE.name().equals(clusterMetadata.getHealthyCheckType())) {
            this.throwHealthCheckerException(groupName, serviceName, clusterName);
        }
        if (null == (client = this.clientManager.getClient(clientId = IpPortBasedClient.getClientId(ip + ":" + port, false)))) {
            return;
        }
        InstancePublishInfo oldInstance = client.getInstancePublishInfo(service);
        if (null == oldInstance) {
            return;
        }
        Instance newInstance = InstanceUtil.parseToApiInstance(service, oldInstance);
        newInstance.setHealthy(healthy);
        this.clientOperationService.registerInstance(service, newInstance, clientId);
    }

    @Override
    public Map<String, AbstractHealthChecker> checkers() {
        List classes = HealthCheckType.getLoadedHealthCheckerClasses();
        HashMap<String, AbstractHealthChecker> checkerMap = new HashMap<String, AbstractHealthChecker>(8);
        for (Class clazz : classes) {
            try {
                AbstractHealthChecker checker = (AbstractHealthChecker)clazz.newInstance();
                checkerMap.put(checker.getType(), checker);
            }
            catch (IllegalAccessException | InstantiationException e) {
                Loggers.EVT_LOG.error("checkers error ", (Throwable)e);
            }
        }
        return checkerMap;
    }

    private void throwHealthCheckerException(String groupName, String serviceName, String clusterName) throws NacosException {
        String errorInfo = String.format("health check is still working, service: %s@@%s, cluster: %s", groupName, serviceName, clusterName);
        throw new NacosException(400, errorInfo);
    }
}

