/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.utils;

import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.utils.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamUtil.class);
    private static int connectTimeout = ParamUtil.initConnectionTimeout();
    private static int readTimeout;
    private static int maxRetryTimes;
    private static long refreshIntervalMills;
    private static final String MAINTAINER_CLIENT_CONNECT_TIMEOUT_KEY = "MAINTAINER.CLIENT.CONNECT.TIMEOUT";
    private static final String MAINTAINER_CLIENT_READ_TIMEOUT_KEY = "MAINTAINER.CLIENT.READ.TIMEOUT";
    private static final String MAINTAINER_CLIENT_MAX_RETRY_TIMES_KEY = "MAINTAINER.CLIENT.MAX.RETRY.TIMES";
    private static final String MAINTAINER_CLIENT_REFRESH_INTERVAL_MILLS_KEY = "MAINTAINER.CLIENT.REFRESH.INTERVAL.MILLS";
    private static final String DEFAULT_CONNECT_TIMEOUT = "2000";
    private static final String DEFAULT_READ_TIMEOUT = "5000";
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final int DEFAULT_REFRESH_INTERVAL_MILLS = 5000;

    private static int initConnectionTimeout() {
        try {
            String connectTimeout = NacosClientProperties.PROTOTYPE.getProperty(MAINTAINER_CLIENT_CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT);
            return Integer.parseInt(connectTimeout);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + connectTimeout;
            LOGGER.error("[settings] {}", (Object)msg, (Object)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static int initReadTimeout() {
        try {
            String readTimeout = NacosClientProperties.PROTOTYPE.getProperty(MAINTAINER_CLIENT_READ_TIMEOUT_KEY, DEFAULT_READ_TIMEOUT);
            return Integer.parseInt(readTimeout);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid read timeout:" + readTimeout;
            LOGGER.error("[settings] {}", (Object)msg, (Object)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static int initMaxRetryTimes() {
        try {
            return Integer.parseInt(NacosClientProperties.PROTOTYPE.getProperty(MAINTAINER_CLIENT_MAX_RETRY_TIMES_KEY, String.valueOf(3)));
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid max retry times:" + maxRetryTimes;
            LOGGER.error("[settings] {}", (Object)msg, (Object)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static long initRefreshIntervalMills() {
        try {
            return Long.parseLong(NacosClientProperties.PROTOTYPE.getProperty(MAINTAINER_CLIENT_REFRESH_INTERVAL_MILLS_KEY, String.valueOf(5000)));
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid auth refresh interval :" + refreshIntervalMills;
            LOGGER.error("[settings] {}", (Object)msg, (Object)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        ParamUtil.connectTimeout = connectTimeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        ParamUtil.readTimeout = readTimeout;
    }

    public static int getMaxRetryTimes() {
        return maxRetryTimes;
    }

    public static String getDefaultNamespaceId() {
        return "public";
    }

    public static String getDefaultGroupName() {
        return "DEFAULT_GROUP";
    }

    public static long getRefreshIntervalMills() {
        return refreshIntervalMills;
    }

    public static void initSerialization() {
        JacksonUtils.registerSubtype(NoneSelector.class, (String)SelectorType.none.name());
        JacksonUtils.registerSubtype(NoneSelector.class, (String)"NoneSelector");
        JacksonUtils.registerSubtype(ExpressionSelector.class, (String)SelectorType.label.name());
        JacksonUtils.registerSubtype(ExpressionSelector.class, (String)"LabelSelector");
    }

    static {
        LOGGER.info("[settings] [maintainer-http-client] connect timeout:{}", (Object)connectTimeout);
        readTimeout = ParamUtil.initReadTimeout();
        LOGGER.info("[settings] [maintainer-http-client] read timeout:{}", (Object)readTimeout);
        maxRetryTimes = ParamUtil.initMaxRetryTimes();
        LOGGER.info("[settings] [maintainer-http-client] max retry times:{}", (Object)maxRetryTimes);
        refreshIntervalMills = ParamUtil.initRefreshIntervalMills();
        LOGGER.info("[settings] [maintainer-http-client] auth refresh interval mills:{}", (Object)refreshIntervalMills);
    }
}

