/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceDetailInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceView;
import com.alibaba.nacos.api.naming.pojo.maintainer.SubscriberInfo;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.maintainer.client.utils.ParamUtil;
import java.util.List;
import java.util.Map;

public interface ServiceMaintainerService {
    default public String createService(String serviceName) throws NacosException {
        return this.createService("DEFAULT_GROUP", serviceName);
    }

    default public String createService(String groupName, String serviceName) throws NacosException {
        return this.createService("public", groupName, serviceName);
    }

    default public String createService(String namespaceId, String groupName, String serviceName) throws NacosException {
        return this.createService(namespaceId, groupName, serviceName, false);
    }

    default public String createService(String namespaceId, String groupName, String serviceName, boolean ephemeral) throws NacosException {
        return this.createService(namespaceId, groupName, serviceName, ephemeral, 0.0f);
    }

    default public String createService(String namespaceId, String groupName, String serviceName, boolean ephemeral, float protectThreshold) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        service.setEphemeral(ephemeral);
        service.setProtectThreshold(protectThreshold);
        return this.createService(service);
    }

    public String createService(Service var1) throws NacosException;

    default public String updateService(String serviceName, Map<String, String> newMetadata, float newProtectThreshold, Selector newSelector) throws NacosException {
        return this.updateService("DEFAULT_GROUP", serviceName, newMetadata, newProtectThreshold, newSelector);
    }

    default public String updateService(String groupName, String serviceName, Map<String, String> newMetadata, float newProtectThreshold, Selector newSelector) throws NacosException {
        return this.updateService(ParamUtil.getDefaultNamespaceId(), groupName, serviceName, newMetadata, newProtectThreshold, newSelector);
    }

    default public String updateService(String namespaceId, String groupName, String serviceName, Map<String, String> newMetadata, float newProtectThreshold, Selector newSelector) throws NacosException {
        return this.updateService(namespaceId, groupName, serviceName, false, newMetadata, newProtectThreshold, newSelector);
    }

    default public String updateService(String namespaceId, String groupName, String serviceName, boolean ephemeral, Map<String, String> newMetadata, float newProtectThreshold, Selector newSelector) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        service.setEphemeral(ephemeral);
        service.setProtectThreshold(newProtectThreshold);
        service.setMetadata(newMetadata);
        service.setSelector(newSelector);
        return this.updateService(service);
    }

    public String updateService(Service var1) throws NacosException;

    default public String removeService(String serviceName) throws NacosException {
        return this.removeService(ParamUtil.getDefaultGroupName(), serviceName);
    }

    default public String removeService(String groupName, String serviceName) throws NacosException {
        return this.removeService(ParamUtil.getDefaultNamespaceId(), groupName, serviceName);
    }

    default public String removeService(String namespaceId, String groupName, String serviceName) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        return this.removeService(service);
    }

    public String removeService(Service var1) throws NacosException;

    default public ServiceDetailInfo getServiceDetail(String serviceName) throws NacosException {
        return this.getServiceDetail("DEFAULT_GROUP", serviceName);
    }

    default public ServiceDetailInfo getServiceDetail(String groupName, String serviceName) throws NacosException {
        return this.getServiceDetail("public", groupName, serviceName);
    }

    default public ServiceDetailInfo getServiceDetail(String namespaceId, String groupName, String serviceName) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        return this.getServiceDetail(service);
    }

    public ServiceDetailInfo getServiceDetail(Service var1) throws NacosException;

    default public Page<ServiceView> listServices(String namespaceId) throws NacosException {
        return this.listServices(namespaceId, "", "");
    }

    default public Page<ServiceView> listServices(String namespaceId, String groupNameParam, String serviceNameParam) throws NacosException {
        return this.listServices(namespaceId, groupNameParam, serviceNameParam, true, 1, 100);
    }

    public Page<ServiceView> listServices(String var1, String var2, String var3, boolean var4, int var5, int var6) throws NacosException;

    default public Page<ServiceDetailInfo> listServicesWithDetail(String namespaceId) throws NacosException {
        return this.listServicesWithDetail(namespaceId, "", "");
    }

    default public Page<ServiceDetailInfo> listServicesWithDetail(String namespaceId, String groupNameParam, String serviceNameParam) throws NacosException {
        return this.listServicesWithDetail(namespaceId, groupNameParam, serviceNameParam, 1, 100);
    }

    public Page<ServiceDetailInfo> listServicesWithDetail(String var1, String var2, String var3, int var4, int var5) throws NacosException;

    default public Page<SubscriberInfo> getSubscribers(String serviceName) throws NacosException {
        return this.getSubscribers("DEFAULT_GROUP", serviceName);
    }

    default public Page<SubscriberInfo> getSubscribers(String groupName, String serviceName) throws NacosException {
        return this.getSubscribers("public", groupName, serviceName);
    }

    default public Page<SubscriberInfo> getSubscribers(String namespaceId, String groupName, String serviceName) throws NacosException {
        return this.getSubscribers(namespaceId, groupName, serviceName, 1, 100);
    }

    default public Page<SubscriberInfo> getSubscribers(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize) throws NacosException {
        return this.getSubscribers(namespaceId, groupName, serviceName, pageNo, pageSize, false);
    }

    default public Page<SubscriberInfo> getSubscribers(String namespaceId, String groupName, String serviceName, int pageNo, int pageSize, boolean aggregation) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        return this.getSubscribers(service, pageNo, pageSize, aggregation);
    }

    public Page<SubscriberInfo> getSubscribers(Service var1, int var2, int var3, boolean var4) throws NacosException;

    public List<String> listSelectorTypes() throws NacosException;
}

