/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.maintainer.InstanceMetadataBatchResult;
import java.util.List;
import java.util.Map;

public interface InstanceMaintainerService {
    default public String registerInstance(String serviceName, String ip, int port) throws NacosException {
        return this.registerInstance("DEFAULT_GROUP", serviceName, ip, port);
    }

    default public String registerInstance(String groupName, String serviceName, String ip, int port) throws NacosException {
        return this.registerInstance("public", groupName, serviceName, ip, port);
    }

    default public String registerInstance(String namespaceId, String groupName, String serviceName, String ip, int port) throws NacosException {
        return this.registerInstance(namespaceId, groupName, serviceName, ip, port, "DEFAULT");
    }

    default public String registerInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        return this.registerInstance("DEFAULT_GROUP", serviceName, ip, port, clusterName);
    }

    default public String registerInstance(String groupName, String serviceName, String ip, int port, String clusterName) throws NacosException {
        return this.registerInstance("public", groupName, serviceName, ip, port, clusterName);
    }

    default public String registerInstance(String namespaceId, String groupName, String serviceName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setClusterName(clusterName);
        instance.setEphemeral(false);
        return this.registerInstance(namespaceId, groupName, serviceName, instance);
    }

    default public String registerInstance(String serviceName, Instance instance) throws NacosException {
        return this.registerInstance("DEFAULT_GROUP", serviceName, instance);
    }

    default public String registerInstance(String groupName, String serviceName, Instance instance) throws NacosException {
        return this.registerInstance("public", groupName, serviceName, instance);
    }

    default public String registerInstance(String namespaceId, String groupName, String serviceName, Instance instance) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        service.setEphemeral(instance.isEphemeral());
        return this.registerInstance(service, instance);
    }

    public String registerInstance(Service var1, Instance var2) throws NacosException;

    default public String deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        return this.deregisterInstance("DEFAULT_GROUP", serviceName, ip, port);
    }

    default public String deregisterInstance(String groupName, String serviceName, String ip, int port) throws NacosException {
        return this.deregisterInstance("public", groupName, serviceName, ip, port);
    }

    default public String deregisterInstance(String namespaceId, String groupName, String serviceName, String ip, int port) throws NacosException {
        return this.deregisterInstance(namespaceId, groupName, serviceName, ip, port, "DEFAULT");
    }

    default public String deregisterInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        return this.deregisterInstance("DEFAULT_GROUP", serviceName, ip, port, clusterName);
    }

    default public String deregisterInstance(String groupName, String serviceName, String ip, int port, String clusterName) throws NacosException {
        return this.deregisterInstance("public", groupName, serviceName, ip, port, clusterName);
    }

    default public String deregisterInstance(String namespaceId, String groupName, String serviceName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setClusterName(clusterName);
        instance.setEphemeral(false);
        return this.deregisterInstance(namespaceId, groupName, serviceName, instance);
    }

    default public String deregisterInstance(String serviceName, Instance instance) throws NacosException {
        return this.deregisterInstance("DEFAULT_GROUP", serviceName, instance);
    }

    default public String deregisterInstance(String groupName, String serviceName, Instance instance) throws NacosException {
        return this.deregisterInstance("public", groupName, serviceName, instance);
    }

    default public String deregisterInstance(String namespaceId, String groupName, String serviceName, Instance instance) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        service.setEphemeral(instance.isEphemeral());
        return this.deregisterInstance(service, instance);
    }

    public String deregisterInstance(Service var1, Instance var2) throws NacosException;

    default public String updateInstance(String serviceName, Instance instance) throws NacosException {
        return this.updateInstance("DEFAULT_GROUP", serviceName, instance);
    }

    default public String updateInstance(String groupName, String serviceName, Instance instance) throws NacosException {
        return this.updateInstance("public", groupName, serviceName, instance);
    }

    default public String updateInstance(String namespaceId, String groupName, String serviceName, Instance instance) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        service.setEphemeral(instance.isEphemeral());
        return this.updateInstance(service, instance);
    }

    public String updateInstance(Service var1, Instance var2) throws NacosException;

    public InstanceMetadataBatchResult batchUpdateInstanceMetadata(Service var1, List<Instance> var2, Map<String, String> var3) throws NacosException;

    public InstanceMetadataBatchResult batchDeleteInstanceMetadata(Service var1, List<Instance> var2, Map<String, String> var3) throws NacosException;

    public String partialUpdateInstance(Service var1, Instance var2) throws NacosException;

    default public List<Instance> listInstances(String serviceName, String clusterName, boolean healthyOnly) throws NacosException {
        return this.listInstances("DEFAULT_GROUP", serviceName, clusterName, healthyOnly);
    }

    default public List<Instance> listInstances(String groupName, String serviceName, String clusterName, boolean healthyOnly) throws NacosException {
        return this.listInstances("public", groupName, serviceName, clusterName, healthyOnly);
    }

    default public List<Instance> listInstances(String namespaceId, String groupName, String serviceName, String clusterName, boolean healthyOnly) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        return this.listInstances(service, clusterName, healthyOnly);
    }

    public List<Instance> listInstances(Service var1, String var2, boolean var3) throws NacosException;

    default public Instance getInstanceDetail(String serviceName, String ip, int port) throws NacosException {
        return this.getInstanceDetail("DEFAULT_GROUP", serviceName, ip, port);
    }

    default public Instance getInstanceDetail(String groupName, String serviceName, String ip, int port) throws NacosException {
        return this.getInstanceDetail("public", groupName, serviceName, ip, port);
    }

    default public Instance getInstanceDetail(String namespaceId, String groupName, String serviceName, String ip, int port) throws NacosException {
        return this.getInstanceDetail(namespaceId, groupName, serviceName, ip, port, "DEFAULT");
    }

    default public Instance getInstanceDetail(String serviceName, String ip, int port, String clusterName) throws NacosException {
        return this.getInstanceDetail("DEFAULT_GROUP", serviceName, ip, port, clusterName);
    }

    default public Instance getInstanceDetail(String groupName, String serviceName, String ip, int port, String clusterName) throws NacosException {
        return this.getInstanceDetail("public", groupName, serviceName, ip, port, clusterName);
    }

    default public Instance getInstanceDetail(String namespaceId, String groupName, String serviceName, String ip, int port, String clusterName) throws NacosException {
        Service service = new Service();
        service.setNamespaceId(namespaceId);
        service.setGroupName(groupName);
        service.setName(serviceName);
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setClusterName(clusterName);
        return this.getInstanceDetail(service, instance);
    }

    public Instance getInstanceDetail(Service var1, Instance var2) throws NacosException;
}

