/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock.persistence;

import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.distributed.raft.utils.RaftExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.lock.LockManager;
import com.alibaba.nacos.lock.core.reentrant.AtomicLockService;
import com.alibaba.nacos.lock.model.LockKey;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alibaba.nacos.sys.utils.TimerContext;
import com.alipay.sofa.jraft.util.CRC64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.zip.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosLockSnapshotOperation
implements SnapshotOperation {
    protected static final String CHECK_SUM_KEY = "checksum";
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final LockManager lockManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosLockSnapshotOperation.class);
    private static final String LOCK_SNAPSHOT_SAVE = NacosLockSnapshotOperation.class.getSimpleName() + ".SAVE";
    private static final String LOCK_SNAPSHOT_LOAD = NacosLockSnapshotOperation.class.getSimpleName() + ".LOAD";
    private final Serializer serializer = SerializeFactory.getDefault();
    private static final String SNAPSHOT_ARCHIVE = "nacos_lock.zip";

    public NacosLockSnapshotOperation(LockManager lockManager, ReentrantReadWriteLock.WriteLock writeLock) {
        this.lockManager = lockManager;
        this.writeLock = writeLock;
    }

    public void onSnapshotSave(Writer writer, BiConsumer<Boolean, Throwable> callFinally) {
        RaftExecutor.doSnapshot(() -> {
            TimerContext.start((String)this.getSnapshotSaveTag());
            ReentrantReadWriteLock.WriteLock lock = this.writeLock;
            lock.lock();
            try {
                callFinally.accept(this.writeSnapshot(writer), null);
            }
            catch (Throwable t) {
                Loggers.RAFT.error("Fail to compress snapshot, path={}, file list={}.", new Object[]{writer.getPath(), writer.listFiles(), t});
                callFinally.accept(false, t);
            }
            finally {
                lock.unlock();
                TimerContext.end((String)this.getSnapshotSaveTag(), (Logger)Loggers.RAFT);
            }
        });
    }

    private boolean writeSnapshot(Writer writer) throws IOException {
        String writePath = writer.getPath();
        String outputFile = Paths.get(writePath, SNAPSHOT_ARCHIVE).toString();
        CRC64 checksum = new CRC64();
        try (InputStream inputStream = this.dumpSnapshot();){
            DiskUtils.compressIntoZipFile((String)"lock", (InputStream)inputStream, (String)outputFile, (Checksum)checksum);
        }
        LocalFileMeta meta = new LocalFileMeta();
        meta.append((Object)CHECK_SUM_KEY, (Object)Long.toHexString(checksum.getValue()));
        return writer.addFile(SNAPSHOT_ARCHIVE, meta);
    }

    private InputStream dumpSnapshot() {
        ConcurrentHashMap<LockKey, AtomicLockService> lockMap = this.lockManager.showLocks();
        return new ByteArrayInputStream(this.serializer.serialize(lockMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSnapshotLoad(Reader reader) {
        TimerContext.start((String)this.getSnapshotLoadTag());
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = this.readSnapshot(reader);
            return bl;
        }
        catch (Throwable t) {
            Loggers.RAFT.error("Fail to load snapshot, path={}, file list={}.", new Object[]{reader.getPath(), reader.listFiles(), t});
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
            TimerContext.end((String)this.getSnapshotLoadTag(), (Logger)Loggers.RAFT);
        }
    }

    private boolean readSnapshot(Reader reader) throws Exception {
        String readerPath = reader.getPath();
        Loggers.RAFT.info("snapshot start to load from : {}", (Object)readerPath);
        String sourceFile = Paths.get(readerPath, SNAPSHOT_ARCHIVE).toString();
        CRC64 checksum = new CRC64();
        byte[] snapshotBytes = DiskUtils.decompress((String)sourceFile, (Checksum)checksum);
        LocalFileMeta fileMeta = reader.getFileMeta(SNAPSHOT_ARCHIVE);
        if (fileMeta.getFileMeta().containsKey(CHECK_SUM_KEY) && !Objects.equals(Long.toHexString(checksum.getValue()), fileMeta.get(CHECK_SUM_KEY))) {
            throw new IllegalArgumentException("Snapshot checksum failed");
        }
        this.loadSnapshot(snapshotBytes);
        Loggers.RAFT.info("snapshot success to load from : {}", (Object)readerPath);
        return true;
    }

    private void loadSnapshot(byte[] snapshotBytes) {
        ConcurrentHashMap newData = (ConcurrentHashMap)this.serializer.deserialize(snapshotBytes);
        ConcurrentHashMap<LockKey, AtomicLockService> lockMap = this.lockManager.showLocks();
        lockMap.putAll(newData);
    }

    protected String getSnapshotSaveTag() {
        return LOCK_SNAPSHOT_SAVE;
    }

    protected String getSnapshotLoadTag() {
        return LOCK_SNAPSHOT_LOAD;
    }
}

