/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock.core.reentrant.mutex;

import com.alibaba.nacos.lock.core.reentrant.AbstractAtomicLock;
import com.alibaba.nacos.lock.model.LockInfo;
import java.util.concurrent.atomic.AtomicInteger;

public class MutexAtomicLock
extends AbstractAtomicLock {
    private static final Integer EMPTY = 0;
    private static final Integer FULL = 1;
    private final AtomicInteger state = new AtomicInteger(EMPTY);
    private Long expiredTimestamp;

    public MutexAtomicLock(String key) {
        super(key);
    }

    @Override
    public Boolean tryLock(LockInfo lockInfo) {
        Long endTime = lockInfo.getEndTime();
        if (this.state.compareAndSet(EMPTY, FULL) || this.autoExpire().booleanValue()) {
            this.expiredTimestamp = endTime;
            return true;
        }
        return false;
    }

    @Override
    public Boolean unLock(LockInfo lockInfo) {
        return this.state.compareAndSet(FULL, EMPTY);
    }

    @Override
    public Boolean autoExpire() {
        return System.currentTimeMillis() >= this.expiredTimestamp;
    }

    @Override
    public Boolean isClear() {
        return EMPTY.equals(this.state.get()) || this.autoExpire() != false;
    }
}

