/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.api.ApiGeneratorFactory;
import com.alibaba.nacos.istio.common.AbstractConnection;
import com.alibaba.nacos.istio.common.NacosResourceManager;
import com.alibaba.nacos.istio.common.ResourceSnapshot;
import com.alibaba.nacos.istio.common.WatchedStatus;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.alibaba.nacos.istio.util.NonceGenerator;
import com.alibaba.nacos.istio.xds.DeltaConnection;
import com.alibaba.nacos.istio.xds.XdsConnection;
import io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryResponse;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosXdsService
extends AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceImplBase {
    private final Map<String, AbstractConnection<DiscoveryResponse>> connections = new ConcurrentHashMap<String, AbstractConnection<DiscoveryResponse>>(16);
    private final Map<String, AbstractConnection<DeltaDiscoveryResponse>> deltaConnections = new ConcurrentHashMap<String, AbstractConnection<DeltaDiscoveryResponse>>(16);
    @Autowired
    ApiGeneratorFactory apiGeneratorFactory;
    @Autowired
    NacosResourceManager resourceManager;

    public boolean hasClientConnection() {
        return this.connections.size() != 0 || this.deltaConnections.size() != 0;
    }

    public StreamObserver<DiscoveryRequest> streamAggregatedResources(final StreamObserver<DiscoveryResponse> responseObserver) {
        this.resourceManager.initResourceSnapshot();
        final XdsConnection newConnection = new XdsConnection(responseObserver);
        return new StreamObserver<DiscoveryRequest>(){
            private boolean initRequest = true;

            public void onNext(DiscoveryRequest discoveryRequest) {
                if (this.initRequest) {
                    newConnection.setConnectionId(discoveryRequest.getNode().getId());
                    NacosXdsService.this.connections.put(newConnection.getConnectionId(), newConnection);
                    this.initRequest = false;
                }
                NacosXdsService.this.process(discoveryRequest, newConnection);
            }

            public void onError(Throwable throwable) {
                Loggers.MAIN.error("xds: {} stream error.", (Object)newConnection.getConnectionId(), (Object)throwable);
                this.clear();
            }

            public void onCompleted() {
                Loggers.MAIN.info("xds: {} stream close.", (Object)newConnection.getConnectionId());
                responseObserver.onCompleted();
                this.clear();
            }

            private void clear() {
                NacosXdsService.this.connections.remove(newConnection.getConnectionId());
            }
        };
    }

    public void process(DiscoveryRequest discoveryRequest, AbstractConnection<DiscoveryResponse> connection) {
        String reason;
        if (!this.shouldPush(discoveryRequest, connection)) {
            return;
        }
        HashSet resourceNames = new HashSet(discoveryRequest.getResourceNamesList());
        PushRequest pushRequest = new PushRequest(this.resourceManager.getResourceSnapshot(), true);
        IstioConfig istioConfig = pushRequest.getResourceSnapshot().getIstioConfig();
        if (discoveryRequest.getTypeUrl().equals("type.googleapis.com/envoy.config.cluster.v3.Cluster")) {
            for (String resourceName : resourceNames) {
                String reason2 = IstioCrdUtil.parseClusterNameToServiceName(resourceName, istioConfig.getDomainSuffix());
                pushRequest.addReason(reason2);
            }
        }
        if (discoveryRequest.getTypeUrl().equals("type.googleapis.com/envoy.config.listener.v3.Listener") && discoveryRequest.getResponseNonce().isEmpty()) {
            reason = "bootstrap_listener";
            pushRequest.addReason(reason);
        }
        if (discoveryRequest.getTypeUrl().equals("type.googleapis.com/envoy.config.route.v3.RouteConfiguration") && discoveryRequest.getResponseNonce().isEmpty()) {
            reason = "default_route_configuration";
            pushRequest.addReason(reason);
            for (String resourceName : resourceNames) {
                pushRequest.addReason(resourceName);
            }
        }
        DiscoveryResponse response = this.buildDiscoveryResponse(discoveryRequest.getTypeUrl(), pushRequest);
        connection.push(response, connection.getWatchedStatusByType(discoveryRequest.getTypeUrl()));
    }

    private boolean shouldPush(DiscoveryRequest discoveryRequest, AbstractConnection<DiscoveryResponse> connection) {
        String type = discoveryRequest.getTypeUrl();
        String connectionId = connection.getConnectionId();
        if (type.equals("core/v1alpha1/MeshConfig")) {
            Loggers.MAIN.info("xds: type {} should be ignored.", (Object)type);
            return false;
        }
        if (discoveryRequest.getErrorDetail().getCode() != 0) {
            Loggers.MAIN.error("xds: ACK error, connection-id: {}, code: {}, message: {}", new Object[]{connectionId, discoveryRequest.getErrorDetail().getCode(), discoveryRequest.getErrorDetail().getMessage()});
            return false;
        }
        if (discoveryRequest.getResponseNonce().isEmpty()) {
            Loggers.MAIN.info("xds: init request, type {}, connection-id {}, version {}", new Object[]{type, connectionId, discoveryRequest.getVersionInfo()});
            Loggers.MAIN.info("xds: content {},{}", (Object)discoveryRequest.getTypeUrl(), (Object)discoveryRequest.getResourceNamesList());
            WatchedStatus watchedStatus = new WatchedStatus();
            watchedStatus.setType(discoveryRequest.getTypeUrl());
            Loggers.MAIN.info("watchedStatus: {}", (Object)watchedStatus);
            connection.addWatchedResource(discoveryRequest.getTypeUrl(), watchedStatus);
            return true;
        }
        WatchedStatus watchedStatus = connection.getWatchedStatusByType(discoveryRequest.getTypeUrl());
        if (watchedStatus == null) {
            Loggers.MAIN.info("xds: reconnect, type {}, connection-id {}, version {}, nonce {}.", new Object[]{type, connectionId, discoveryRequest.getVersionInfo(), discoveryRequest.getResponseNonce()});
            Loggers.MAIN.info("xds: content {},{}", (Object)discoveryRequest.getTypeUrl(), (Object)discoveryRequest.getResourceNamesList());
            watchedStatus = new WatchedStatus();
            watchedStatus.setType(discoveryRequest.getTypeUrl());
            Loggers.MAIN.info("watchedStatus: {}", (Object)watchedStatus);
            connection.addWatchedResource(discoveryRequest.getTypeUrl(), watchedStatus);
            return true;
        }
        if (!watchedStatus.getLatestNonce().equals(discoveryRequest.getResponseNonce())) {
            Loggers.MAIN.warn("xds: request dis match, type {}, connection-id {}", (Object)discoveryRequest.getTypeUrl(), (Object)connection.getConnectionId());
            return false;
        }
        watchedStatus.setAckedVersion(discoveryRequest.getVersionInfo());
        watchedStatus.setAckedNonce(discoveryRequest.getResponseNonce());
        Loggers.MAIN.info("xds: ack, type {}, connection-id {}, version {}, nonce {}", new Object[]{type, connectionId, discoveryRequest.getVersionInfo(), discoveryRequest.getResponseNonce()});
        return false;
    }

    public void handleEvent(PushRequest pushRequest) {
        if (this.connections.size() == 0) {
            return;
        }
        for (AbstractConnection<DiscoveryResponse> connection : this.connections.values()) {
            WatchedStatus ldsWatchedStatus;
            WatchedStatus edsWatchedStatus;
            DiscoveryResponse cdsResponse;
            WatchedStatus cdsWatchedStatus;
            WatchedStatus watchedStatus = connection.getWatchedStatusByType("networking.istio.io/v1alpha3/ServiceEntry");
            if (watchedStatus != null) {
                DiscoveryResponse serviceEntryResponse = this.buildDiscoveryResponse("networking.istio.io/v1alpha3/ServiceEntry", pushRequest);
                connection.push(serviceEntryResponse, watchedStatus);
            }
            if ((cdsWatchedStatus = connection.getWatchedStatusByType("type.googleapis.com/envoy.config.cluster.v3.Cluster")) != null && (cdsResponse = this.buildDiscoveryResponse("type.googleapis.com/envoy.config.cluster.v3.Cluster", pushRequest)) != null) {
                connection.push(cdsResponse, cdsWatchedStatus);
            }
            if ((edsWatchedStatus = connection.getWatchedStatusByType("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment")) != null) {
                DiscoveryResponse edsResponse = this.buildDiscoveryResponse("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment", pushRequest);
                connection.push(edsResponse, edsWatchedStatus);
            }
            if ((ldsWatchedStatus = connection.getWatchedStatusByType("type.googleapis.com/envoy.config.listener.v3.Listener")) == null) continue;
            DiscoveryResponse ldsResponse = this.buildDiscoveryResponse("type.googleapis.com/envoy.config.listener.v3.Listener", pushRequest);
            connection.push(ldsResponse, ldsWatchedStatus);
        }
    }

    public void handleConfigEvent(PushRequest pushRequest) {
        if (this.connections.size() == 0) {
            return;
        }
        for (AbstractConnection<DiscoveryResponse> connection : this.connections.values()) {
            WatchedStatus rdsWatchedStatus;
            WatchedStatus watchedStatus = connection.getWatchedStatusByType("type.googleapis.com/envoy.config.route.v3.RouteConfiguration");
            if (watchedStatus == null) {
                watchedStatus = new WatchedStatus();
                watchedStatus.setType("type.googleapis.com/envoy.config.route.v3.RouteConfiguration");
                connection.addWatchedResource("type.googleapis.com/envoy.config.route.v3.RouteConfiguration", watchedStatus);
            }
            if ((rdsWatchedStatus = connection.getWatchedStatusByType("type.googleapis.com/envoy.config.route.v3.RouteConfiguration")) == null) continue;
            DiscoveryResponse rdsResponse = this.buildDiscoveryResponse("type.googleapis.com/envoy.config.route.v3.RouteConfiguration", pushRequest);
            connection.push(rdsResponse, rdsWatchedStatus);
        }
    }

    private DiscoveryResponse buildDiscoveryResponse(String type, PushRequest pushRequest) {
        ApiGenerator<?> generator = this.apiGeneratorFactory.getApiGenerator(type);
        List<?> rawResources = generator.generate(pushRequest);
        if (rawResources == null) {
            return null;
        }
        String nonce = NonceGenerator.generateNonce();
        return DiscoveryResponse.newBuilder().setTypeUrl(type).addAllResources(rawResources).setVersionInfo(pushRequest.getResourceSnapshot().getVersion()).setNonce(nonce).build();
    }

    public StreamObserver<DeltaDiscoveryRequest> deltaAggregatedResources(final StreamObserver<DeltaDiscoveryResponse> responseObserver) {
        this.resourceManager.initResourceSnapshot();
        final DeltaConnection newConnection = new DeltaConnection(responseObserver);
        return new StreamObserver<DeltaDiscoveryRequest>(){
            private boolean initRequest = true;

            public void onNext(DeltaDiscoveryRequest deltaDiscoveryRequest) {
                if (this.initRequest) {
                    newConnection.setConnectionId(deltaDiscoveryRequest.getNode().getId());
                    NacosXdsService.this.deltaConnections.put(newConnection.getConnectionId(), newConnection);
                    this.initRequest = false;
                }
                NacosXdsService.this.deltaProcess(deltaDiscoveryRequest, newConnection);
            }

            public void onError(Throwable throwable) {
                Loggers.MAIN.error("delta xds: {} stream error.", (Object)newConnection.getConnectionId(), (Object)throwable);
                this.clear();
            }

            public void onCompleted() {
                Loggers.MAIN.info("delta xds: {} stream close.", (Object)newConnection.getConnectionId());
                responseObserver.onCompleted();
                this.clear();
            }

            private void clear() {
                NacosXdsService.this.deltaConnections.remove(newConnection.getConnectionId());
            }
        };
    }

    public void deltaProcess(DeltaDiscoveryRequest deltaDiscoveryRequest, AbstractConnection<DeltaDiscoveryResponse> connection) {
        if (!this.deltaShouldPush(deltaDiscoveryRequest, connection)) {
            return;
        }
        ResourceSnapshot resourceSnapshot = this.resourceManager.getResourceSnapshot();
        PushRequest pushRequest = new PushRequest(resourceSnapshot, true);
        HashSet<String> subscribe = new HashSet<String>((Collection<String>)deltaDiscoveryRequest.getResourceNamesSubscribeList());
        pushRequest.setSubscribe(subscribe);
        connection.getWatchedStatusByType(deltaDiscoveryRequest.getTypeUrl()).setLastSubscribe(subscribe);
        DeltaDiscoveryResponse response = this.buildDeltaDiscoveryResponse(deltaDiscoveryRequest.getTypeUrl(), pushRequest);
        connection.push(response, connection.getWatchedStatusByType(deltaDiscoveryRequest.getTypeUrl()));
    }

    private boolean deltaShouldPush(DeltaDiscoveryRequest deltaDiscoveryRequest, AbstractConnection<DeltaDiscoveryResponse> connection) {
        String type = deltaDiscoveryRequest.getTypeUrl();
        String connectionId = connection.getConnectionId();
        if (type.equals("core/v1alpha1/MeshConfig")) {
            Loggers.MAIN.info("delta xds: type {} should be ignored.", (Object)type);
            return false;
        }
        if (deltaDiscoveryRequest.getResponseNonce().isEmpty()) {
            Loggers.MAIN.info("delta xds: init request, type {}, connection-id {}", (Object)type, (Object)connectionId);
            WatchedStatus watchedStatus = new WatchedStatus();
            watchedStatus.setType(deltaDiscoveryRequest.getTypeUrl());
            connection.addWatchedResource(deltaDiscoveryRequest.getTypeUrl(), watchedStatus);
            return true;
        }
        WatchedStatus watchedStatus = connection.getWatchedStatusByType(deltaDiscoveryRequest.getTypeUrl());
        if (watchedStatus == null) {
            Loggers.MAIN.info("delta xds: reconnect, type {}, connection-id {}, nonce {}.", new Object[]{type, connectionId, deltaDiscoveryRequest.getResponseNonce()});
            watchedStatus = new WatchedStatus();
            watchedStatus.setType(deltaDiscoveryRequest.getTypeUrl());
            connection.addWatchedResource(deltaDiscoveryRequest.getTypeUrl(), watchedStatus);
            return true;
        }
        if (deltaDiscoveryRequest.getErrorDetail().getCode() != 0) {
            Loggers.MAIN.error("delta xds: ACK error, connection-id: {}, code: {}, message: {}", new Object[]{connectionId, deltaDiscoveryRequest.getErrorDetail().getCode(), deltaDiscoveryRequest.getErrorDetail().getMessage()});
            watchedStatus.setLastAckOrNack(true);
            return false;
        }
        if (!watchedStatus.getLatestNonce().equals(deltaDiscoveryRequest.getResponseNonce())) {
            Loggers.MAIN.warn("delta xds: request dis match, type {}, connection-id {}", (Object)deltaDiscoveryRequest.getTypeUrl(), (Object)connection.getConnectionId());
            return false;
        }
        watchedStatus.setAckedNonce(deltaDiscoveryRequest.getResponseNonce());
        watchedStatus.setLastSubscribe(new HashSet<String>((Collection<String>)deltaDiscoveryRequest.getResourceNamesSubscribeList()));
        Loggers.MAIN.info("delta xds: ack, type {}, connection-id {}, nonce {}", new Object[]{type, connectionId, deltaDiscoveryRequest.getResponseNonce()});
        return false;
    }

    public void handleDeltaEvent(PushRequest pushRequest) {
        if (this.deltaConnections.size() == 0) {
            return;
        }
        pushRequest.setFull(pushRequest.getResourceSnapshot().getIstioConfig().isFullEnabled());
        for (AbstractConnection<DeltaDiscoveryResponse> connection : this.deltaConnections.values()) {
            WatchedStatus edsWatchedStatus;
            WatchedStatus watchedStatus = connection.getWatchedStatusByType("networking.istio.io/v1alpha3/ServiceEntry");
            if (watchedStatus != null && watchedStatus.isLastAckOrNack()) {
                pushRequest.setSubscribe(watchedStatus.getLastSubscribe());
                DeltaDiscoveryResponse serviceEntryResponse = this.buildDeltaDiscoveryResponse("networking.istio.io/v1alpha3/ServiceEntry", pushRequest);
                if (serviceEntryResponse != null) {
                    connection.push(serviceEntryResponse, watchedStatus);
                }
            }
            if ((edsWatchedStatus = connection.getWatchedStatusByType("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment")) == null || !edsWatchedStatus.isLastAckOrNack()) continue;
            pushRequest.setSubscribe(edsWatchedStatus.getLastSubscribe());
            DeltaDiscoveryResponse edsResponse = this.buildDeltaDiscoveryResponse("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment", pushRequest);
            if (edsResponse == null) continue;
            connection.push(edsResponse, edsWatchedStatus);
        }
    }

    private DeltaDiscoveryResponse buildDeltaDiscoveryResponse(String type, PushRequest pushRequest) {
        ApiGenerator<?> generator = this.apiGeneratorFactory.getApiGenerator(type);
        List<Resource> rawResources = generator.deltaGenerate(pushRequest);
        if (rawResources == null) {
            return null;
        }
        String nonce = NonceGenerator.generateNonce();
        return DeltaDiscoveryResponse.newBuilder().setTypeUrl(type).addAllResources(rawResources).addAllRemovedResources(pushRequest.getRemoved()).setSystemVersionInfo(pushRequest.getResourceSnapshot().getVersion()).setNonce(nonce).build();
    }
}

