/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.IstioEndpoint;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.google.protobuf.Any;
import com.google.protobuf.UInt32Value;
import io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EdsGenerator
implements ApiGenerator<Any> {
    private static volatile EdsGenerator singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EdsGenerator getInstance() {
        if (singleton != null) return singleton;
        Class<EdsGenerator> clazz = EdsGenerator.class;
        synchronized (EdsGenerator.class) {
            if (singleton != null) return singleton;
            singleton = new EdsGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public List<Any> generate(PushRequest pushRequest) {
        ArrayList<Any> result = new ArrayList<Any>();
        IstioConfig istioConfig = pushRequest.getResourceSnapshot().getIstioConfig();
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        if (pushRequest.getReason().size() != 0) {
            for (String reason : pushRequest.getReason()) {
                IstioService istioService = istioServiceMap.get(reason);
                String name = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", reason + "." + istioConfig.getDomainSuffix(), istioService.getPort());
                Any any = EdsGenerator.buildEndpoint(name, istioService);
                if (any == null) continue;
                result.add(any);
            }
        } else {
            for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
                String name = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", entry.getKey() + "." + istioConfig.getDomainSuffix(), entry.getValue().getPort());
                Any any = EdsGenerator.buildEndpoint(name, entry.getValue());
                if (any == null) continue;
                result.add(any);
            }
        }
        return result;
    }

    @Override
    public List<Resource> deltaGenerate(PushRequest pushRequest) {
        if (pushRequest.isFull()) {
            return null;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        Set<String> reason = pushRequest.getReason();
        IstioConfig istioConfig = pushRequest.getResourceSnapshot().getIstioConfig();
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        if (pushRequest.getSubscribe().size() != 0) {
            for (String subscribe : pushRequest.getSubscribe()) {
                String serviceName = IstioCrdUtil.parseClusterNameToServiceName(subscribe, istioConfig.getDomainSuffix());
                if (!reason.contains(serviceName)) continue;
                if (istioServiceMap.containsKey(serviceName)) {
                    Any any = EdsGenerator.buildEndpoint(subscribe, istioServiceMap.get(serviceName));
                    if (any != null) {
                        result.add(Resource.newBuilder().setResource(any).setVersion(pushRequest.getResourceSnapshot().getVersion()).build());
                        continue;
                    }
                    pushRequest.addRemoved(subscribe);
                    continue;
                }
                pushRequest.addRemoved(subscribe);
            }
        } else {
            for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
                String name = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", entry.getKey() + "." + istioConfig.getDomainSuffix(), entry.getValue().getPort());
                Any any = EdsGenerator.buildEndpoint(name, entry.getValue());
                if (any != null) {
                    result.add(Resource.newBuilder().setResource(any).setVersion(pushRequest.getResourceSnapshot().getVersion()).build());
                    continue;
                }
                pushRequest.addRemoved(name);
            }
        }
        return result;
    }

    private static Any buildEndpoint(String name, IstioService istioService) {
        if (istioService.getHosts().isEmpty()) {
            return null;
        }
        List<IstioEndpoint> istioEndpoints = istioService.getHosts();
        HashMap<String, Object> llbEndpointsBuilder = new HashMap<String, Object>(istioEndpoints.size());
        for (IstioEndpoint istioEndpoint : istioEndpoints) {
            String label = istioEndpoint.getStringLocality();
            LbEndpoint lbEndpoint = istioEndpoint.getLbEndpoint();
            if (!llbEndpointsBuilder.containsKey(label)) {
                LocalityLbEndpoints.Builder llbEndpointBuilder = LocalityLbEndpoints.newBuilder().setLocality(istioEndpoint.getLocality()).addLbEndpoints(lbEndpoint);
                llbEndpointsBuilder.put(label, llbEndpointBuilder);
                continue;
            }
            ((LocalityLbEndpoints.Builder)llbEndpointsBuilder.get(label)).addLbEndpoints(lbEndpoint);
        }
        ArrayList<LocalityLbEndpoints> listlle = new ArrayList<LocalityLbEndpoints>();
        for (LocalityLbEndpoints.Builder builder : llbEndpointsBuilder.values()) {
            int weight = 0;
            for (LbEndpoint lbEndpoint : builder.getLbEndpointsList()) {
                weight += lbEndpoint.getLoadBalancingWeight().getValue();
            }
            LocalityLbEndpoints lle = builder.setLoadBalancingWeight(UInt32Value.newBuilder().setValue(weight)).build();
            listlle.add(lle);
        }
        if (listlle.size() == 0) {
            return null;
        }
        ClusterLoadAssignment clusterLoadAssignment = ClusterLoadAssignment.newBuilder().setClusterName(name).addAllEndpoints(listlle).build();
        return Any.newBuilder().setValue(clusterLoadAssignment.toByteString()).setTypeUrl("type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment").build();
    }
}

