/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.google.protobuf.Any;
import io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.envoyproxy.envoy.config.core.v3.AggregatedConfigSource;
import io.envoyproxy.envoy.config.core.v3.ConfigSource;
import io.envoyproxy.envoy.config.core.v3.Http1ProtocolOptions;
import io.envoyproxy.envoy.config.core.v3.Http2ProtocolOptions;
import io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CdsGenerator
implements ApiGenerator<Any> {
    private static volatile CdsGenerator singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CdsGenerator getInstance() {
        if (singleton != null) return singleton;
        Class<CdsGenerator> clazz = CdsGenerator.class;
        synchronized (CdsGenerator.class) {
            if (singleton != null) return singleton;
            singleton = new CdsGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public List<Any> generate(PushRequest pushRequest) {
        if (!pushRequest.isFull()) {
            return null;
        }
        ArrayList<Any> result = new ArrayList<Any>();
        IstioConfig istioConfig = pushRequest.getResourceSnapshot().getIstioConfig();
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
            String name = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", entry.getKey() + "." + istioConfig.getDomainSuffix(), entry.getValue().getPort());
            Cluster.Builder cluster = Cluster.newBuilder().setName(name).setType(Cluster.DiscoveryType.EDS).setEdsClusterConfig(Cluster.EdsClusterConfig.newBuilder().setServiceName(name).setEdsConfig(ConfigSource.newBuilder().setAds(AggregatedConfigSource.newBuilder()).setResourceApiVersionValue(1).build()).build());
            if ("grpc".equals(entry.getValue().getProtocol())) {
                cluster.setHttp2ProtocolOptions(Http2ProtocolOptions.newBuilder().build());
            } else {
                cluster.setHttpProtocolOptions(Http1ProtocolOptions.newBuilder().build());
            }
            result.add(Any.newBuilder().setValue(cluster.build().toByteString()).setTypeUrl("type.googleapis.com/envoy.config.cluster.v3.Cluster").build());
        }
        return result;
    }

    @Override
    public List<Resource> deltaGenerate(PushRequest pushRequest) {
        Loggers.MAIN.info("Delta Cds Not supported");
        return null;
    }
}

