/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.server;

import com.alibaba.nacos.istio.mcp.NacosMcpService;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.server.ServerInterceptor;
import com.alibaba.nacos.istio.xds.NacosXdsService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IstioServer {
    private Server server;
    @Autowired
    private IstioConfig istioConfig;
    @Autowired
    private ServerInterceptor serverInterceptor;
    @Autowired
    private NacosMcpService nacosMcpService;
    @Autowired
    private NacosXdsService nacosXdsService;

    @PostConstruct
    public void start() throws IOException {
        if (!this.istioConfig.isServerEnabled()) {
            Loggers.MAIN.info("The Nacos Istio server is disabled.");
            return;
        }
        Loggers.MAIN.info("Nacos Istio server, starting Nacos Istio server...");
        this.server = ServerBuilder.forPort((int)this.istioConfig.getServerPort()).addService(ServerInterceptors.intercept((BindableService)this.nacosMcpService, (io.grpc.ServerInterceptor[])new io.grpc.ServerInterceptor[]{this.serverInterceptor})).addService(ServerInterceptors.intercept((BindableService)this.nacosXdsService, (io.grpc.ServerInterceptor[])new io.grpc.ServerInterceptor[]{this.serverInterceptor})).build();
        this.server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                IstioServer.this.stop();
            }
        });
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }
}

