/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.model;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.protobuf.UInt32Value;
import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.Locality;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.config.endpoint.v3.Endpoint;
import io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IstioEndpoint {
    private LbEndpoint lbEndpoint;
    private Instance instance;
    private Locality locality;
    private String protocol;
    private String hostName;
    private String clusterName;

    public IstioEndpoint(Instance instance) {
        this.instance = instance;
        this.hostName = StringUtils.isNotEmpty((String)((String)instance.getMetadata().get("istio.hostname"))) ? (String)instance.getMetadata().get("istio.hostname") : "";
        String string = this.clusterName = StringUtils.isNotEmpty((String)instance.getClusterName()) ? instance.getClusterName() : "";
        if (StringUtils.isNotEmpty((String)((String)instance.getMetadata().get("protocol")))) {
            this.protocol = (String)instance.getMetadata().get("protocol");
            if ("triple".equals(this.protocol) || "tri".equals(this.protocol)) {
                this.protocol = "grpc";
            }
        } else {
            this.protocol = "http";
        }
        this.buildLocality();
    }

    private void buildLocality() {
        String region = this.instance.getMetadata().getOrDefault("region", "");
        String zone = this.instance.getMetadata().getOrDefault("zone", "");
        String subzone = this.instance.getMetadata().getOrDefault("subzone", "");
        this.locality = Locality.newBuilder().setRegion(region).setZone(zone).setSubZone(subzone).build();
    }

    private LbEndpoint buildLbEndpoint() {
        Address adder = Address.newBuilder().setSocketAddress(SocketAddress.newBuilder().setAddress(this.instance.getIp()).setPortValue(this.instance.getPort()).setProtocol(SocketAddress.Protocol.TCP).build()).build();
        this.lbEndpoint = LbEndpoint.newBuilder().setLoadBalancingWeight(UInt32Value.newBuilder().setValue((int)this.instance.getWeight())).setEndpoint(Endpoint.newBuilder().setAddress(adder).build()).build();
        return this.lbEndpoint;
    }

    public Map<String, String> getLabels() {
        return this.instance.getMetadata();
    }

    public String getAdder() {
        return this.instance.getIp();
    }

    public LbEndpoint getLbEndpoint() {
        return this.buildLbEndpoint();
    }

    public String getStringLocality() {
        return this.locality.getRegion() + "." + this.locality.getZone() + "." + this.locality.getSubZone();
    }

    public Locality getLocality() {
        return this.locality;
    }

    public int getPort() {
        return this.instance.getPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getWeight() {
        return (int)this.instance.getWeight();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean isHealthy() {
        return this.instance.isHealthy();
    }

    public boolean isEnabled() {
        return this.instance.isEnabled();
    }
}

