/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.mcp;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.common.ResourceSnapshot;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.model.ServiceEntryWrapper;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.google.protobuf.Any;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import istio.mcp.v1alpha1.MetadataOuterClass;
import istio.mcp.v1alpha1.ResourceOuterClass;
import istio.networking.v1alpha3.ServiceEntryOuterClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServiceEntryMcpGenerator
implements ApiGenerator<ResourceOuterClass.Resource> {
    private List<ServiceEntryWrapper> serviceEntries;
    private static volatile ServiceEntryMcpGenerator singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceEntryMcpGenerator getInstance() {
        if (singleton != null) return singleton;
        Class<ServiceEntryMcpGenerator> clazz = ServiceEntryMcpGenerator.class;
        synchronized (ServiceEntryMcpGenerator.class) {
            if (singleton != null) return singleton;
            singleton = new ServiceEntryMcpGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public List<ResourceOuterClass.Resource> generate(PushRequest pushRequest) {
        ArrayList<ResourceOuterClass.Resource> result = new ArrayList<ResourceOuterClass.Resource>();
        this.serviceEntries = new ArrayList<ServiceEntryWrapper>(16);
        ResourceSnapshot resourceSnapshot = pushRequest.getResourceSnapshot();
        IstioConfig istioConfig = resourceSnapshot.getIstioConfig();
        Map<String, IstioService> serviceInfoMap = resourceSnapshot.getIstioResources().getIstioServiceMap();
        for (Map.Entry<String, IstioService> entry : serviceInfoMap.entrySet()) {
            String serviceName = entry.getKey();
            ServiceEntryWrapper serviceEntryWrapper = IstioCrdUtil.buildServiceEntry(serviceName, serviceName + istioConfig.getDomainSuffix(), serviceInfoMap.get(serviceName));
            if (serviceEntryWrapper == null) continue;
            this.serviceEntries.add(serviceEntryWrapper);
        }
        for (ServiceEntryWrapper serviceEntryWrapper : this.serviceEntries) {
            MetadataOuterClass.Metadata metadata = serviceEntryWrapper.getMetadata();
            ServiceEntryOuterClass.ServiceEntry serviceEntry = serviceEntryWrapper.getServiceEntry();
            Any any = Any.newBuilder().setValue(serviceEntry.toByteString()).setTypeUrl("type.googleapis.com/istio.networking.v1alpha3.ServiceEntry").build();
            result.add(ResourceOuterClass.Resource.newBuilder().setBody(any).setMetadata(metadata).build());
        }
        return result;
    }

    @Override
    public List<Resource> deltaGenerate(PushRequest pushRequest) {
        return new ArrayList<Resource>();
    }
}

