/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.inner.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.console.handler.core.NamespaceHandler;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.core.namespace.model.form.NamespaceForm;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@EnabledInnerHandler
public class NamespaceInnerHandler
implements NamespaceHandler {
    private final NamespaceOperationService namespaceOperationService;

    public NamespaceInnerHandler(NamespaceOperationService namespaceOperationService) {
        this.namespaceOperationService = namespaceOperationService;
    }

    @Override
    public List<Namespace> getNamespaceList() {
        return this.namespaceOperationService.getNamespaceList();
    }

    @Override
    public Namespace getNamespaceDetail(String namespaceId) throws NacosException {
        return this.namespaceOperationService.getNamespace(namespaceId);
    }

    @Override
    public Boolean createNamespace(String namespaceId, String namespaceName, String namespaceDesc) throws NacosException {
        return this.namespaceOperationService.createNamespace(namespaceId, namespaceName, namespaceDesc);
    }

    @Override
    public Boolean updateNamespace(NamespaceForm namespaceForm) throws NacosException {
        return this.namespaceOperationService.editNamespace(namespaceForm.getNamespaceId(), namespaceForm.getNamespaceName(), namespaceForm.getNamespaceDesc());
    }

    @Override
    public Boolean deleteNamespace(String namespaceId) {
        return this.namespaceOperationService.removeNamespace(namespaceId);
    }

    @Override
    public Boolean checkNamespaceIdExist(String namespaceId) {
        try {
            return this.namespaceOperationService.isNamespaceExist(namespaceId);
        }
        catch (NacosApiException e) {
            return true;
        }
    }
}

