/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.core;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.NacosMember;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.console.proxy.core.ClusterProxy;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.Collection;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/core/cluster"})
public class ConsoleClusterController {
    private final ClusterProxy clusterProxy;

    public ConsoleClusterController(ClusterProxy clusterProxy) {
        this.clusterProxy = clusterProxy;
    }

    @GetMapping(value={"/nodes"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.READ, signType="console", apiType=ApiType.CONSOLE_API)
    public Result<Collection<NacosMember>> getNodeList(@RequestParam(value="keyword", required=false) String ipKeyWord) throws NacosException {
        Collection<NacosMember> result = this.clusterProxy.getNodeList(ipKeyWord);
        return Result.success(result);
    }
}

