/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.config;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigHistoryBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigHistoryDetailInfo;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.console.proxy.config.HistoryProxy;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/cs/history"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConsoleHistoryController {
    private final HistoryProxy historyProxy;

    @Autowired
    public ConsoleHistoryController(HistoryProxy historyProxy) {
        this.historyProxy = historyProxy;
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<ConfigHistoryDetailInfo> getConfigHistoryInfo(ConfigFormV3 configForm, @RequestParam(value="nid") Long nid) throws NacosException {
        configForm.validate();
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        return Result.success((Object)this.historyProxy.getConfigHistoryInfo(dataId, groupName, namespaceId, nid));
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<Page<ConfigHistoryBasicInfo>> listConfigHistory(ConfigFormV3 configForm, PageForm pageForm) throws NacosException {
        configForm.validate();
        pageForm.validate();
        int pageSize = Math.min(500, pageForm.getPageSize());
        int pageNo = pageForm.getPageNo();
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        return Result.success(this.historyProxy.listConfigHistory(dataId, groupName, namespaceId, pageNo, pageSize));
    }

    @GetMapping(value={"/previous"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<ConfigHistoryDetailInfo> getPreviousConfigHistoryInfo(ConfigFormV3 configForm, @RequestParam(value="id") Long id) throws NacosException {
        configForm.validate();
        String dataId = configForm.getDataId();
        String groupName = configForm.getGroupName();
        String namespaceId = NamespaceUtil.processNamespaceParameter((String)configForm.getNamespaceId());
        return Result.success((Object)this.historyProxy.getPreviousConfigHistoryInfo(dataId, groupName, namespaceId, id));
    }

    @GetMapping(value={"/configs"})
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.CONSOLE_API)
    public Result<List<ConfigBasicInfo>> getConfigsByTenant(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        namespaceId = NamespaceUtil.processNamespaceParameter((String)namespaceId);
        return Result.success(this.historyProxy.getConfigsByTenant(namespaceId));
    }
}

