/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.console.paramcheck.ConsoleDefaultHttpParamExtractor;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.namespace.model.form.NamespaceForm;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/console/namespace"})
@ExtractorManager.Extractor(httpExtractor=ConsoleDefaultHttpParamExtractor.class)
@EnabledInnerHandler
public class NamespaceControllerV2 {
    private final NamespaceOperationService namespaceOperationService;
    private NamespacePersistService namespacePersistService;
    private final Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private final Pattern namespaceNameCheckPattern = Pattern.compile("^[^@#$%^&*]+$");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;

    public NamespaceControllerV2(NamespaceOperationService namespaceOperationService, NamespacePersistService namespacePersistService) {
        this.namespaceOperationService = namespaceOperationService;
        this.namespacePersistService = namespacePersistService;
    }

    @GetMapping(value={"/list"})
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/core/namespace/list")
    public Result<List<Namespace>> getNamespaceList() {
        return Result.success((Object)this.namespaceOperationService.getNamespaceList());
    }

    @GetMapping
    @Secured(resource="console/namespaces", action=ActionTypes.READ, signType="console")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/core/namespace")
    public Result<Namespace> getNamespace(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return Result.success((Object)this.namespaceOperationService.getNamespace(namespaceId));
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="POST ${contextPath:nacos}/v3/console/core/namespace")
    public Result<Boolean> createNamespace(NamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        String namespaceId = namespaceForm.getNamespaceId();
        String namespaceName = namespaceForm.getNamespaceName();
        String namespaceDesc = namespaceForm.getNamespaceDesc();
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceId [" + namespaceId + "] mismatch the pattern");
            }
            if (namespaceId.length() > 128) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "too long namespaceId, over 128");
            }
            if (this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) > 0) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "the namespaceId is existed, namespaceId: " + namespaceForm.getNamespaceId());
            }
        }
        if (!this.namespaceNameCheckPattern.matcher(namespaceName).matches()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceName [" + namespaceName + "] contains illegal char");
        }
        return Result.success((Object)this.namespaceOperationService.createNamespace(namespaceId, namespaceName, namespaceDesc));
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="PUT ${contextPath:nacos}/v3/console/core/namespace")
    public Result<Boolean> editNamespace(NamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        if (!this.namespaceNameCheckPattern.matcher(namespaceForm.getNamespaceName()).matches()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceName [" + namespaceForm.getNamespaceName() + "] contains illegal char");
        }
        return Result.success((Object)this.namespaceOperationService.editNamespace(namespaceForm.getNamespaceId(), namespaceForm.getNamespaceName(), namespaceForm.getNamespaceDesc()));
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE, signType="console")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="DELETE ${contextPath:nacos}/v3/console/core/namespace")
    public Result<Boolean> deleteNamespace(@RequestParam(value="namespaceId") String namespaceId) {
        return Result.success((Object)this.namespaceOperationService.removeNamespace(namespaceId));
    }
}

