/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.listener.startup.AbstractNacosStartUp;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class NacosConsoleStartUp
extends AbstractNacosStartUp {
    private static final String MODE_PROPERTY_KEY_STAND_MODE = "nacos.mode";
    private static final String MODE_PROPERTY_KEY_FUNCTION_MODE = "nacos.function.mode";
    private static final String NACOS_MODE_STAND_ALONE = "stand alone";
    private static final String DEFAULT_FUNCTION_MODE = "All";
    private static final String LOCAL_IP_PROPERTY_KEY = "nacos.local.ip";
    private static final String NACOS_APPLICATION_CONF = "nacos_application_conf";
    private static final Map<String, Object> SOURCES = new ConcurrentHashMap<String, Object>();
    private boolean isConsoleDeploymentType;

    public NacosConsoleStartUp() {
        super("console");
    }

    protected String getPhaseNameInStartingInfo() {
        return "Nacos Console";
    }

    public String[] makeWorkDir() {
        this.isConsoleDeploymentType = "console".equals(System.getProperty("nacos.deployment.type"));
        if (this.isConsoleDeploymentType) {
            try {
                Path path = Paths.get(EnvUtil.getNacosHome(), "logs");
                DiskUtils.forceMkdir((File)new File(path.toUri()));
            }
            catch (Exception e) {
                throw new NacosRuntimeException(ErrorCode.IOMakeDirError.getCode(), (Throwable)e);
            }
            return new String[]{EnvUtil.getNacosHome() + File.separator + "logs"};
        }
        return super.makeWorkDir();
    }

    public void injectEnvironment(ConfigurableEnvironment environment) {
        if (this.isConsoleDeploymentType) {
            EnvUtil.setEnvironment((ConfigurableEnvironment)environment);
        }
    }

    public void loadPreProperties(ConfigurableEnvironment environment) {
        if (this.isConsoleDeploymentType) {
            try {
                SOURCES.putAll(EnvUtil.loadProperties((Resource)EnvUtil.getApplicationConfFileResource()));
                environment.getPropertySources().addLast((PropertySource)new OriginTrackedMapPropertySource(NACOS_APPLICATION_CONF, SOURCES));
            }
            catch (Exception e) {
                throw new NacosRuntimeException(500, (Throwable)e);
            }
        }
    }

    public void initSystemProperty() {
        if (this.isConsoleDeploymentType) {
            System.setProperty(LOCAL_IP_PROPERTY_KEY, InetUtils.getSelfIP());
            System.setProperty(MODE_PROPERTY_KEY_STAND_MODE, NACOS_MODE_STAND_ALONE);
            if (EnvUtil.getFunctionMode() == null) {
                System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, DEFAULT_FUNCTION_MODE);
            } else if ("config".equals(EnvUtil.getFunctionMode())) {
                System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, "config");
            } else if ("naming".equals(EnvUtil.getFunctionMode())) {
                System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, "naming");
            }
        }
    }

    public void logStarted(Logger logger) {
        long endTimestamp = System.currentTimeMillis();
        long startupCost = endTimestamp - this.getStartTimestamp();
        logger.info("Nacos Console started successfully in {} ms", (Object)startupCost);
    }
}

