/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.config.server.model.ConfigListenState;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.utils.Md5Comparator;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

public class NacosMd5Comparator
implements Md5Comparator {
    @Override
    public String getName() {
        return "nacos";
    }

    @Override
    public Map<String, ConfigListenState> compareMd5(HttpServletRequest request, HttpServletResponse response, Map<String, ConfigListenState> clientMd5Map) {
        HashMap<String, ConfigListenState> changedGroupKeys = new HashMap<String, ConfigListenState>(clientMd5Map.size());
        String tag = request.getHeader("Vipserver-Tag");
        for (Map.Entry<String, ConfigListenState> entry : clientMd5Map.entrySet()) {
            String ip;
            String clientMd5;
            String groupKey = entry.getKey();
            boolean isUptodate = ConfigCacheService.isUptodate(groupKey, clientMd5 = entry.getValue().getMd5(), ip = RequestUtil.getRemoteIp(request), tag);
            if (isUptodate) continue;
            changedGroupKeys.put(entry.getKey(), entry.getValue());
        }
        return changedGroupKeys;
    }
}

