/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.config.server.constant.Constants;

public class ContentUtils {
    private static final int LIMIT_CONTENT_SIZE = 100;

    public static void verifyIncrementPubContent(String content) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("The content for publishing or deleting cannot be null!");
        }
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("The content for publishing or deleting cannot contain enter and next line symbol!");
            }
            if (c != Constants.WORD_SEPARATOR.charAt(0)) continue;
            throw new IllegalArgumentException("The content for publishing or deleting cannot contain (char)2!");
        }
    }

    public static String getContentIdentity(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("The content does not contain separator!");
        }
        return content.substring(0, index);
    }

    public static String getContent(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("The content does not contain separator!");
        }
        return content.substring(index + 1);
    }

    public static String truncateContent(String content) {
        if (content == null) {
            return "";
        }
        if (content.length() <= 100) {
            return content;
        }
        return content.substring(0, 100) + "...";
    }
}

