/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import java.util.Arrays;

public class ConfigTagUtil {
    public static final String VIRTUAL_SERVICE = "virtual-service";
    public static final String DESTINATION_RULE = "destination-rule";
    private static final String TAGS_DELIMITER = ",";
    private static final String HYPHEN = "-";

    public static boolean isIstio(String configTags) {
        if (configTags == null) {
            return false;
        }
        if (configTags.isEmpty()) {
            return false;
        }
        return Arrays.stream(configTags.split(TAGS_DELIMITER)).map(tag -> tag.trim().replaceAll(HYPHEN, "")).anyMatch(tag -> tag.equalsIgnoreCase(VIRTUAL_SERVICE.replaceAll(HYPHEN, "")) || tag.equalsIgnoreCase(DESTINATION_RULE.replaceAll(HYPHEN, "")));
    }

    public static String getIstioType(String configTags) {
        if (configTags == null) {
            throw new IllegalArgumentException("configTags cannot be null.");
        }
        if (configTags.isEmpty()) {
            return null;
        }
        return Arrays.stream(configTags.split(TAGS_DELIMITER)).map(tag -> tag.trim().replaceAll(HYPHEN, "")).filter(tag -> tag.equalsIgnoreCase(VIRTUAL_SERVICE.replaceAll(HYPHEN, "")) || tag.equalsIgnoreCase(DESTINATION_RULE.replaceAll(HYPHEN, ""))).findFirst().orElse(null);
    }
}

