/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnExternalStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoTagMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoTagPersistServiceImpl")
public class ExternalConfigInfoTagPersistServiceImpl
implements ConfigInfoTagPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalConfigInfoTagPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfo4TagState(String dataId, String group, String tenant, String tag) {
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            return (ConfigInfoStateWrapper)this.jt.queryForObject(configInfoTagMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{dataId, group, tenantTmp, tag}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private ConfigOperateResult getTagOperateResult(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoStateWrapper configInfo4Tag = this.findConfigInfo4TagState(dataId, group, tenantTmp, tag);
        if (configInfo4Tag == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4Tag.getId(), configInfo4Tag.getLastModified());
    }

    @Override
    public ConfigOperateResult addConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        try {
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.jt.update(configInfoTagMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "tag_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_create", "gmt_modified")), new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time});
            return this.getTagOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigOperateResult insertOrUpdateTag(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        if (this.findConfigInfo4TagState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), tag) == null) {
            return this.addConfigInfo4Tag(configInfo, tag, srcIp, srcUser);
        }
        return this.updateConfigInfo4Tag(configInfo, tag, srcIp, srcUser);
    }

    @Override
    public ConfigOperateResult insertOrUpdateTagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        if (this.findConfigInfo4TagState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), tag) == null) {
            return this.addConfigInfo4Tag(configInfo, tag, srcIp, srcUser);
        }
        return this.updateConfigInfo4TagCas(configInfo, tag, srcIp, srcUser);
    }

    @Override
    public void removeConfigInfoTag(String dataId, String group, String tenant, String tag, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag;
        try {
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            this.jt.update(configInfoTagMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{dataId, group, tenantTmp, tagTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigOperateResult updateConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.jt.update(configInfoTagMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified", "app_name"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp});
            return this.getTagOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigOperateResult updateConfigInfo4TagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            boolean success;
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            MapperContext context = new MapperContext();
            context.putUpdateParameter("content", (Object)configInfo.getContent());
            context.putUpdateParameter("md5", (Object)md5);
            context.putUpdateParameter("srcIp", (Object)srcIp);
            context.putUpdateParameter("srcUser", (Object)srcUser);
            context.putUpdateParameter("gmtModified", (Object)time);
            context.putUpdateParameter("app_name", (Object)appNameTmp);
            context.putWhereParameter("dataId", (Object)configInfo.getDataId());
            context.putWhereParameter("groupId", (Object)configInfo.getGroup());
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            context.putWhereParameter("tagId", (Object)tagTmp);
            context.putWhereParameter("md5", (Object)configInfo.getMd5());
            MapperResult mapperResult = configInfoTagMapper.updateConfigInfo4TagCas(context);
            boolean bl = success = this.jt.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) > 0;
            if (success) {
                return this.getTagOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp);
            }
            return new ConfigOperateResult(false);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoTagWrapper findConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        try {
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            return (ConfigInfoTagWrapper)this.jt.queryForObject(configInfoTagMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "tag_id", "app_name", "content", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id")), new Object[]{dataId, group, tenantTmp, tagTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoTagCount() {
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sql = configInfoTagMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoTagCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoTagWrapper> findAllConfigInfoTagForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sqlCountRows = configInfoTagMapper.count(null);
        MapperResult sqlFetchRows = configInfoTagMapper.findAllConfigInfoTagForDumpAllFetchRows(new MapperContext(startRow, pageSize));
        PaginationHelper helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + String.valueOf((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> findConfigInfoTags(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String selectSql = configInfoTagMapper.select(Collections.singletonList("tag_id"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return this.jt.queryForList(selectSql, new Object[]{dataId, group, tenantTmp}, String.class);
    }
}

