/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.listener;

import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.config.server.service.listener.LocalConfigListenerStateServiceImpl;
import com.alibaba.nacos.config.server.service.listener.RemoteConfigListenerStateServiceImpl;
import org.springframework.stereotype.Service;

@Service
public class ConfigListenerStateDelegate {
    private final LocalConfigListenerStateServiceImpl localService;
    private final RemoteConfigListenerStateServiceImpl remoteService;

    public ConfigListenerStateDelegate(LocalConfigListenerStateServiceImpl localService, RemoteConfigListenerStateServiceImpl remoteService) {
        this.localService = localService;
        this.remoteService = remoteService;
    }

    public ConfigListenerInfo getListenerState(String dataId, String groupName, String namespaceId, boolean aggregation) {
        ConfigListenerInfo result = this.localService.getListenerState(dataId, groupName, namespaceId);
        if (aggregation) {
            result.getListenersStatus().putAll(this.remoteService.getListenerState(dataId, groupName, namespaceId).getListenersStatus());
        }
        return result;
    }

    public ConfigListenerInfo getListenerStateByIp(String ip, boolean aggregation) {
        ConfigListenerInfo result = this.localService.getListenerStateByIp(ip);
        if (aggregation) {
            result.getListenersStatus().putAll(this.remoteService.getListenerStateByIp(ip).getListenersStatus());
        }
        return result;
    }
}

