/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.common.utils.Observable;
import com.alibaba.nacos.common.utils.Observer;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.config.server.service.ConfigMigrateService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.consistency.ProtocolMetaData;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedDumpService
extends DumpService {
    final String[] retryMessages = new String[]{"The conformance protocol is temporarily unavailable for reading"};
    final String[] errorMessages = new String[]{"FSMCaller is overload.", "STATE_ERROR"};
    private final ProtocolManager protocolManager;

    public EmbeddedDumpService(ConfigInfoPersistService configInfoPersistService, NamespacePersistService namespacePersistService, HistoryConfigInfoPersistService historyConfigInfoPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService, ServerMemberManager memberManager, ProtocolManager protocolManager, ConfigMigrateService configMigrateService) {
        super(configInfoPersistService, namespacePersistService, historyConfigInfoPersistService, configInfoGrayPersistService, memberManager, configMigrateService);
        this.protocolManager = protocolManager;
    }

    @Override
    @PostConstruct
    protected void init() throws Throwable {
        if (EnvUtil.getStandaloneMode()) {
            this.dumpOperate();
            return;
        }
        final CPProtocol protocol = this.protocolManager.getCpProtocol();
        final AtomicReference<Object> errorReference = new AtomicReference<Object>(null);
        final CountDownLatch waitDumpFinish = new CountDownLatch(1);
        Observer observer = new Observer(){

            public void update(Observable o) {
                if (!(o instanceof ProtocolMetaData.ValueItem)) {
                    return;
                }
                Object arg = ((ProtocolMetaData.ValueItem)o).getData();
                GlobalExecutor.executeByCommon(() -> {
                    if (Objects.isNull(arg)) {
                        return;
                    }
                    EmbeddedStorageContextHolder.putExtendInfo((String)"00--0-read-join-0--00", (String)"true");
                    boolean canEnd = false;
                    while (true) {
                        block4: {
                            try {
                                EmbeddedDumpService.this.dumpOperate();
                                protocol.protocolMetaData().unSubscribe("nacos_config", "leader", (Observer)this);
                                canEnd = true;
                            }
                            catch (Throwable ex) {
                                if (EmbeddedDumpService.this.shouldRetry(ex)) break block4;
                                errorReference.set(ex);
                                canEnd = true;
                            }
                        }
                        if (canEnd) break;
                        ThreadUtils.sleep((long)500L);
                    }
                    ThreadUtils.countDown((CountDownLatch)waitDumpFinish);
                    EmbeddedStorageContextHolder.cleanAllContext();
                });
            }
        };
        protocol.protocolMetaData().subscribe("nacos_config", "leader", observer);
        ThreadUtils.latchAwait((CountDownLatch)waitDumpFinish);
        Throwable ex = errorReference.get();
        if (Objects.nonNull(ex)) {
            throw ex;
        }
    }

    private boolean shouldRetry(Throwable ex) {
        String errMsg = ex.getMessage();
        for (String failedMsg : this.errorMessages) {
            if (!StringUtils.containsIgnoreCase((CharSequence)errMsg, (CharSequence)failedMsg)) continue;
            return false;
        }
        for (String retryMsg : this.retryMessages) {
            if (!StringUtils.containsIgnoreCase((CharSequence)errMsg, (CharSequence)retryMsg)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute() {
        if (EnvUtil.getStandaloneMode()) {
            return true;
        }
        CPProtocol protocol = this.protocolManager.getCpProtocol();
        return protocol.isLeader("nacos_config");
    }
}

