/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.ConfigMigrateService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DumpChangeGrayConfigWorker
implements Runnable {
    Timestamp startTime;
    ConfigInfoGrayPersistService configInfoGrayPersistService;
    ConfigMigrateService configMigrateService;
    private final HistoryConfigInfoPersistService historyConfigInfoPersistService;
    int pageSize = 100;

    public DumpChangeGrayConfigWorker(ConfigInfoGrayPersistService configInfoGrayPersistService, Timestamp startTime, HistoryConfigInfoPersistService historyConfigInfoPersistService, ConfigMigrateService configMigrateService) {
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.startTime = startTime;
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        this.configMigrateService = configMigrateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!PropertyUtil.isDumpChangeOn()) {
                LogUtil.DEFAULT_LOG.info("DumpGrayChange task is not open");
                return;
            }
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            LogUtil.DEFAULT_LOG.info("DumpGrayChange start ,from time {},current time {}", (Object)this.startTime, (Object)currentTime);
            LogUtil.DEFAULT_LOG.info("Start to check delete configs from  time {}", (Object)this.startTime);
            long startDeletedConfigTime = System.currentTimeMillis();
            long deleteCursorId = 0L;
            while (true) {
                List<ConfigInfoStateWrapper> configDeleted = this.historyConfigInfoPersistService.findDeletedConfig(this.startTime, deleteCursorId, this.pageSize, "gray");
                for (ConfigInfoStateWrapper configInfo : configDeleted) {
                    ConfigInfoStateWrapper configInfoStateWrapper;
                    String grayName = configInfo.getGrayName();
                    if (StringUtils.isBlank((CharSequence)grayName) || (configInfoStateWrapper = this.configInfoGrayPersistService.findConfigInfo4GrayState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), grayName)) != null) continue;
                    ConfigCacheService.removeGray(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), grayName);
                    LogUtil.DEFAULT_LOG.info("[dump-gray-delete-ok], groupKey: {}, tenant: {}, grayName: {}", new Object[]{GroupKey2.getKey(configInfo.getDataId(), configInfo.getGroup()), configInfo.getTenant(), grayName});
                    this.configMigrateService.checkDeletedConfigGrayMigrateState(configInfoStateWrapper);
                }
                if (configDeleted.size() < this.pageSize) break;
                deleteCursorId = configDeleted.get(configDeleted.size() - 1).getId();
            }
            LogUtil.DEFAULT_LOG.info("Check delete configs finished,cost:{}", (Object)(System.currentTimeMillis() - startDeletedConfigTime));
            LogUtil.DEFAULT_LOG.info("Check changeGrayConfig start");
            long startChangeConfigTime = System.currentTimeMillis();
            long changeCursorId = 0L;
            while (true) {
                LogUtil.DEFAULT_LOG.info("Check changed gray configs from  time {},lastMaxId={}", (Object)this.startTime, (Object)changeCursorId);
                List<ConfigInfoGrayWrapper> changeConfigs = this.configInfoGrayPersistService.findChangeConfig(this.startTime, changeCursorId, this.pageSize);
                for (ConfigInfoGrayWrapper cf : changeConfigs) {
                    boolean md5Update;
                    this.configMigrateService.checkChangedConfigGrayMigrateState(cf);
                    if (StringUtils.isBlank((CharSequence)cf.getTenant())) continue;
                    String groupKey = GroupKey2.getKey(cf.getDataId(), cf.getGroup(), cf.getTenant());
                    boolean newLastModified = cf.getLastModified() > ConfigCacheService.getLastModifiedTs(groupKey);
                    String localContentMd5 = ConfigCacheService.getContentMd5(groupKey);
                    boolean bl = md5Update = !localContentMd5.equals(cf.getMd5());
                    if (!newLastModified && !md5Update) continue;
                    LogUtil.DEFAULT_LOG.info("[dump-change-gray] find change config  {}, {}, md5={}", new Object[]{groupKey, cf.getLastModified(), cf.getMd5()});
                    LogUtil.DUMP_LOG.info("[dump-change-gray] find change config  {}, {}, md5={}", new Object[]{groupKey, cf.getLastModified(), cf.getMd5()});
                    ConfigCacheService.dumpGray(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getGrayName(), cf.getGrayRule(), cf.getContent(), cf.getLastModified(), cf.getEncryptedDataKey());
                    String content = cf.getContent();
                    String md5 = MD5Utils.md5Hex((String)content, (String)"GBK");
                    String md5Utf8 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
                    LogUtil.DEFAULT_LOG.info("[dump-change-gray-ok] {}, {}, length={}, md5={},md5UTF8={}", new Object[]{groupKey, cf.getLastModified(), content.length(), md5, md5Utf8});
                }
                if (changeConfigs.size() < this.pageSize) break;
                changeCursorId = changeConfigs.get(changeConfigs.size() - 1).getId();
            }
            long endChangeConfigTime = System.currentTimeMillis();
            LogUtil.DEFAULT_LOG.info("Check changed gray configs finished,cost:{}, next task running will from start time  {}", (Object)(endChangeConfigTime - startChangeConfigTime), (Object)currentTime);
            this.startTime = currentTime;
        }
        catch (Throwable e) {
            LogUtil.DEFAULT_LOG.error("Check changed gray configs error", e);
        }
        finally {
            ConfigExecutor.scheduleConfigChangeTask(this, PropertyUtil.getDumpChangeWorkerInterval(), TimeUnit.MILLISECONDS);
            LogUtil.DEFAULT_LOG.info("Next dump gray change will scheduled after {} milliseconds", (Object)PropertyUtil.getDumpChangeWorkerInterval());
        }
    }
}

