/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.capacity.GroupCapacity;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.GroupCapacityMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class GroupCapacityPersistService {
    static final String CLUSTER = "";
    private static final GroupCapacityRowMapper GROUP_CAPACITY_ROW_MAPPER = new GroupCapacityRowMapper();
    private JdbcTemplate jdbcTemplate;
    private DataSourceService dataSourceService;
    private MapperManager mapperManager;

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    public GroupCapacity getGroupCapacity(String groupId) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putWhereParameter("groupId", (Object)groupId);
        MapperResult mapperResult = groupCapacityMapper.select(context);
        List list = this.jdbcTemplate.query(mapperResult.getSql(), (RowMapper)GROUP_CAPACITY_ROW_MAPPER, mapperResult.getParamList().toArray());
        if (list.isEmpty()) {
            return null;
        }
        return (GroupCapacity)list.get(0);
    }

    public Capacity getClusterCapacity() {
        return this.getGroupCapacity(CLUSTER);
    }

    public boolean insertGroupCapacity(GroupCapacity capacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("groupId", (Object)capacity.getGroupName());
        context.putUpdateParameter("quota", (Object)capacity.getQuota());
        context.putUpdateParameter("maxSize", (Object)capacity.getMaxSize());
        context.putUpdateParameter("maxAggrSize", (Object)capacity.getMaxAggrSize());
        context.putUpdateParameter("maxAggrCount", (Object)capacity.getMaxAggrCount());
        context.putUpdateParameter("gmtCreate", (Object)capacity.getGmtCreate());
        context.putUpdateParameter("gmtModified", (Object)capacity.getGmtModified());
        context.putWhereParameter("groupId", (Object)capacity.getGroupName());
        MapperResult mapperResult = CLUSTER.equals(capacity.getGroupName()) ? groupCapacityMapper.insertIntoSelect(context) : groupCapacityMapper.insertIntoSelectByWhere(context);
        return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) > 0;
    }

    public int getClusterUsage() {
        Capacity clusterCapacity = this.getClusterCapacity();
        if (clusterCapacity != null) {
            return clusterCapacity.getUsage();
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.count(null);
        Integer result = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    public boolean incrementUsageWithDefaultQuotaLimit(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)groupCapacity.getGmtModified());
        context.putWhereParameter("groupId", (Object)groupCapacity.getGroupName());
        context.putWhereParameter("usage", (Object)groupCapacity.getQuota());
        MapperResult mapperResult = groupCapacityMapper.incrementUsageByWhereQuotaEqualZero(context);
        try {
            int affectRow = this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithQuotaLimit(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)groupCapacity.getGmtModified());
        context.putWhereParameter("groupId", (Object)groupCapacity.getGroupName());
        MapperResult mapperResult = groupCapacityMapper.incrementUsageByWhereQuotaNotEqualZero(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsage(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)groupCapacity.getGmtModified());
        context.putWhereParameter("groupId", (Object)groupCapacity.getGroupName());
        MapperResult mapperResult = groupCapacityMapper.incrementUsageByWhere(context);
        try {
            int affectRow = this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean decrementUsage(GroupCapacity groupCapacity) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)groupCapacity.getGmtModified());
        context.putWhereParameter("groupId", (Object)groupCapacity.getGroupName());
        MapperResult mapperResult = groupCapacityMapper.decrementUsageByWhere(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateGroupCapacity(String group, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        List argList = CollectionUtils.list((Object[])new Object[0]);
        List columnList = CollectionUtils.list((Object[])new String[0]);
        if (quota != null) {
            columnList.add("quota");
            argList.add(quota);
        }
        if (maxSize != null) {
            columnList.add("max_size");
            argList.add(maxSize);
        }
        if (maxAggrCount != null) {
            columnList.add("max_aggr_count");
            argList.add(maxAggrCount);
        }
        if (maxAggrSize != null) {
            columnList.add("max_aggr_size");
            argList.add(maxAggrSize);
        }
        columnList.add("gmt_modified");
        argList.add(TimeUtils.getCurrentTime());
        List whereList = CollectionUtils.list((Object[])new String[0]);
        whereList.add("group_id");
        argList.add(group);
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        String sql = groupCapacityMapper.update(columnList, whereList);
        try {
            return this.jdbcTemplate.update(sql, argList.toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateQuota(String group, Integer quota) {
        return this.updateGroupCapacity(group, quota, null, null, null);
    }

    public boolean updateMaxSize(String group, Integer maxSize) {
        return this.updateGroupCapacity(group, null, maxSize, null, null);
    }

    public boolean correctUsage(String group, Timestamp gmtModified) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)gmtModified);
        context.putWhereParameter("groupId", (Object)group);
        if (CLUSTER.equals(group)) {
            MapperResult mapperResult = groupCapacityMapper.updateUsage(context);
            try {
                return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
                throw e;
            }
        }
        MapperResult mapperResult = groupCapacityMapper.updateUsageByWhere(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public List<GroupCapacity> getCapacityList4CorrectUsage(long lastId, int pageSize) {
        GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)lastId);
        context.setPageSize(pageSize);
        MapperResult mapperResult = groupCapacityMapper.selectGroupInfoBySize(context);
        try {
            return this.jdbcTemplate.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (rs, rowNum) -> {
                GroupCapacity groupCapacity = new GroupCapacity();
                groupCapacity.setId(rs.getLong("id"));
                groupCapacity.setGroupName(rs.getString("group_id"));
                return groupCapacity;
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean deleteGroupCapacity(String group) {
        try {
            GroupCapacityMapper groupCapacityMapper = (GroupCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "group_capacity");
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement(groupCapacityMapper.delete(Collections.singletonList("group_id")));
                ps.setString(1, group);
                return ps;
            };
            return this.jdbcTemplate.update(preparedStatementCreator) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    static final class GroupCapacityRowMapper
    implements RowMapper<GroupCapacity> {
        GroupCapacityRowMapper() {
        }

        public GroupCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
            GroupCapacity groupCapacity = new GroupCapacity();
            groupCapacity.setId(rs.getLong("id"));
            groupCapacity.setQuota(rs.getInt("quota"));
            groupCapacity.setUsage(rs.getInt("usage"));
            groupCapacity.setMaxSize(rs.getInt("max_size"));
            groupCapacity.setMaxAggrCount(rs.getInt("max_aggr_count"));
            groupCapacity.setMaxAggrSize(rs.getInt("max_aggr_size"));
            groupCapacity.setGroupName(rs.getString("group_id"));
            return groupCapacity;
        }
    }
}

