/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.enums.OperationType;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfoDetail;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HistoryService {
    private final HistoryConfigInfoPersistService historyConfigInfoPersistService;
    private final ConfigInfoPersistService configInfoPersistService;
    private final ConfigInfoGrayPersistService configInfoGrayPersistService;

    public HistoryService(HistoryConfigInfoPersistService historyConfigInfoPersistService, ConfigInfoPersistService configInfoPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService) {
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
    }

    public Page<ConfigHistoryInfo> listConfigHistory(String dataId, String group, String namespaceId, Integer pageNo, Integer pageSize) {
        return this.historyConfigInfoPersistService.findConfigHistory(dataId, group, namespaceId, pageNo, pageSize);
    }

    public ConfigHistoryInfo getConfigHistoryInfo(String dataId, String group, String namespaceId, Long nid) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.historyConfigInfoPersistService.detailConfigHistory(nid);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, namespaceId);
        String encryptedDataKey = configHistoryInfo.getEncryptedDataKey();
        Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)configHistoryInfo.getContent());
        configHistoryInfo.setContent((String)pair.getSecond());
        return configHistoryInfo;
    }

    public ConfigHistoryInfo getPreviousConfigHistoryInfo(String dataId, String group, String namespaceId, Long id) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.historyConfigInfoPersistService.detailPreviousConfigHistory(id);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, namespaceId);
        String encryptedDataKey = configHistoryInfo.getEncryptedDataKey();
        Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)configHistoryInfo.getContent());
        configHistoryInfo.setContent((String)pair.getSecond());
        return configHistoryInfo;
    }

    public List<ConfigInfoWrapper> getConfigListByNamespace(String namespaceId) {
        return this.configInfoPersistService.queryConfigInfoByNamespace(namespaceId);
    }

    private void checkHistoryInfoPermission(ConfigHistoryInfo configHistoryInfo, String dataId, String group, String namespaceId) throws AccessException {
        if (!(Objects.equals(configHistoryInfo.getDataId(), dataId) && Objects.equals(configHistoryInfo.getGroup(), group) && Objects.equals(configHistoryInfo.getTenant(), namespaceId))) {
            throw new AccessException("Please check dataId, group or namespaceId.");
        }
    }

    public ConfigHistoryInfoDetail getConfigHistoryInfoDetail(String dataId, String group, String namespaceId, Long nid) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.historyConfigInfoPersistService.detailConfigHistory(nid);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, namespaceId);
        ConfigHistoryInfoDetail configHistoryInfoDetail = new ConfigHistoryInfoDetail();
        BeanUtils.copyProperties((Object)configHistoryInfo, (Object)configHistoryInfoDetail);
        configHistoryInfoDetail.setOpType(configHistoryInfoDetail.getOpType().trim());
        if (OperationType.INSERT.getValue().equals(configHistoryInfoDetail.getOpType())) {
            configHistoryInfoDetail.setUpdatedContent(configHistoryInfo.getContent());
            configHistoryInfoDetail.setUpdatedMd5(configHistoryInfo.getMd5());
            configHistoryInfoDetail.setUpdatedEncryptedDataKey(configHistoryInfo.getEncryptedDataKey());
            configHistoryInfoDetail.setUpdateExtInfo(configHistoryInfo.getExtInfo());
            configHistoryInfoDetail.setOriginalExtInfo("");
            configHistoryInfoDetail.setOriginalContent("");
            configHistoryInfoDetail.setOriginalMd5("");
            configHistoryInfoDetail.setOriginalEncryptedDataKey("");
        }
        if (OperationType.UPDATE.getValue().equals(configHistoryInfoDetail.getOpType())) {
            configHistoryInfoDetail.setOriginalExtInfo(configHistoryInfo.getExtInfo());
            configHistoryInfoDetail.setOriginalContent(configHistoryInfo.getContent());
            configHistoryInfoDetail.setOriginalMd5(configHistoryInfo.getMd5());
            configHistoryInfoDetail.setOriginalEncryptedDataKey(configHistoryInfo.getEncryptedDataKey());
            ConfigHistoryInfo nextHistoryInfo = this.historyConfigInfoPersistService.getNextHistoryInfo(dataId, group, namespaceId, configHistoryInfoDetail.getPublishType(), configHistoryInfoDetail.getGrayName(), nid);
            ConfigInfoBase currentConfigInfo = null;
            if (Objects.isNull(nextHistoryInfo)) {
                currentConfigInfo = StringUtils.isEmpty((String)configHistoryInfoDetail.getGrayName()) ? this.configInfoPersistService.findConfigInfo(dataId, group, namespaceId) : this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, namespaceId, configHistoryInfoDetail.getGrayName());
                nextHistoryInfo = this.historyConfigInfoPersistService.getNextHistoryInfo(dataId, group, namespaceId, configHistoryInfoDetail.getPublishType(), configHistoryInfoDetail.getGrayName(), nid);
            }
            if (nextHistoryInfo != null) {
                configHistoryInfoDetail.setUpdateExtInfo(nextHistoryInfo.getExtInfo());
                configHistoryInfoDetail.setUpdatedContent(nextHistoryInfo.getContent());
                configHistoryInfoDetail.setUpdatedMd5(nextHistoryInfo.getMd5());
                configHistoryInfoDetail.setUpdatedEncryptedDataKey(nextHistoryInfo.getEncryptedDataKey());
            } else {
                configHistoryInfoDetail.setUpdatedContent(currentConfigInfo.getContent());
                configHistoryInfoDetail.setUpdatedMd5(currentConfigInfo.getMd5());
                configHistoryInfoDetail.setUpdatedEncryptedDataKey(currentConfigInfo.getEncryptedDataKey());
            }
        }
        if (OperationType.DELETE.getValue().equals(configHistoryInfoDetail.getOpType())) {
            configHistoryInfoDetail.setOriginalMd5(configHistoryInfo.getMd5());
            configHistoryInfoDetail.setOriginalContent(configHistoryInfo.getContent());
            configHistoryInfoDetail.setOriginalEncryptedDataKey(configHistoryInfo.getEncryptedDataKey());
            configHistoryInfoDetail.setOriginalExtInfo(configHistoryInfo.getExtInfo());
        }
        if (StringUtils.isNotBlank((String)configHistoryInfoDetail.getOriginalContent())) {
            String originalContent = (String)EncryptionHandler.decryptHandler((String)dataId, (String)configHistoryInfoDetail.getOriginalEncryptedDataKey(), (String)configHistoryInfoDetail.getOriginalContent()).getSecond();
            configHistoryInfoDetail.setOriginalContent(originalContent);
        }
        if (StringUtils.isNotBlank((String)configHistoryInfoDetail.getUpdatedContent())) {
            String updatedContent = (String)EncryptionHandler.decryptHandler((String)dataId, (String)configHistoryInfoDetail.getUpdatedEncryptedDataKey(), (String)configHistoryInfoDetail.getUpdatedContent()).getSecond();
            configHistoryInfoDetail.setUpdatedContent(updatedContent);
        }
        return configHistoryInfoDetail;
    }
}

