/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.config.server.configuration.ConfigCompatibleConfig;
import com.alibaba.nacos.config.server.exception.ConfigAlreadyExistsException;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoGrayWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.model.gray.ConfigGrayPersistInfo;
import com.alibaba.nacos.config.server.model.gray.GrayRule;
import com.alibaba.nacos.config.server.model.gray.GrayRuleManager;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoGrayPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigMigratePersistService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ConfigMigrateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMigrateService.class);
    private static final String NAMESPACE_MIGRATE_SRC_USER = "nacos_namespace_migrate";
    private final String namespacePublic = "public";
    ConfigInfoBetaPersistService configInfoBetaPersistService;
    ConfigInfoTagPersistService configInfoTagPersistService;
    ConfigInfoGrayPersistService configInfoGrayPersistService;
    ConfigInfoPersistService configInfoPersistService;
    ConfigMigratePersistService configMigratePersistService;
    NamespacePersistService namespacePersistService;
    boolean oldTableVersion = false;

    public ConfigMigrateService(ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoTagPersistService configInfoTagPersistService, ConfigInfoGrayPersistService configInfoGrayPersistService, ConfigMigratePersistService configMigratePersistService, NamespacePersistService namespacePersistService, ConfigInfoPersistService configInfoPersistService) {
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoGrayPersistService = configInfoGrayPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
        this.configMigratePersistService = configMigratePersistService;
        this.namespacePersistService = namespacePersistService;
        this.configInfoPersistService = configInfoPersistService;
    }

    @PostConstruct
    public void migrate() throws Exception {
        this.oldTableVersion = this.namespacePersistService.isExistTable("config_info_beta");
        if (PropertyUtil.isGrayCompatibleModel() && this.oldTableVersion) {
            this.doCheckMigrate();
        }
        if (ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            this.doCheckNamespaceMigrate();
        }
    }

    public void persistTagv1(ConfigForm configForm, ConfigInfo configInfo, ConfigRequestInfo configRequestInfo) throws NacosApiException {
        if (!PropertyUtil.isGrayCompatibleModel() || !this.oldTableVersion) {
            return;
        }
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            ConfigOperateResult configOperateResult = this.configInfoTagPersistService.insertOrUpdateTagCas(configInfo, configForm.getTag(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
            if (!configOperateResult.isSuccess()) {
                LOGGER.warn("[cas-publish-tag-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5()});
                throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish tag config fail, server md5 may have changed.");
            }
        } else {
            this.configInfoTagPersistService.insertOrUpdateTag(configInfo, configForm.getTag(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
        }
    }

    public void persistBeta(ConfigForm configForm, ConfigInfo configInfo, ConfigRequestInfo configRequestInfo) throws NacosApiException {
        if (!PropertyUtil.isGrayCompatibleModel() || !this.oldTableVersion) {
            return;
        }
        ConfigOperateResult configOperateResult = null;
        if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
            configOperateResult = this.configInfoBetaPersistService.insertOrUpdateBetaCas(configInfo, configRequestInfo.getBetaIps(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
            if (!configOperateResult.isSuccess()) {
                LOGGER.warn("[cas-publish-beta-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5()});
                throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish beta config fail, server md5 may have changed.");
            }
        } else {
            this.configInfoBetaPersistService.insertOrUpdateBeta(configInfo, configRequestInfo.getBetaIps(), configRequestInfo.getSrcIp(), configForm.getSrcUser());
        }
    }

    public void deleteConfigGrayV1(String dataId, String group, String namespaceId, String grayName, String clientIp, String srcUser) {
        if (!PropertyUtil.isGrayCompatibleModel() || !this.oldTableVersion) {
            return;
        }
        if ("beta".equals(grayName)) {
            this.configInfoBetaPersistService.removeConfigInfo4Beta(dataId, group, namespaceId);
        } else if (grayName.startsWith("tag_")) {
            this.configInfoTagPersistService.removeConfigInfoTag(dataId, group, namespaceId, grayName.substring(4), clientIp, srcUser);
        }
    }

    public void checkMigrateBeta(String dataId, String group, String tenant) {
        ConfigInfoBetaWrapper configInfo4Beta = this.configInfoBetaPersistService.findConfigInfo4Beta(dataId, group, tenant);
        if (configInfo4Beta == null) {
            ConfigInfoGrayWrapper configInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "beta");
            if (configInfoGrayWrapper == null) {
                return;
            }
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, tenant, "beta", NetUtils.localIp(), "nacos_auto_migrate");
            return;
        }
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "beta");
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < configInfo4Beta.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate beta to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{configInfo4Beta.getDataId(), configInfo4Beta.getGroup(), configInfo4Beta.getTenant(), configInfo4Beta.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("beta", "1.0.0", configInfo4Beta.getBetaIps(), Integer.MAX_VALUE);
            this.configInfoGrayPersistService.insertOrUpdateGray(configInfo4Beta, "beta", GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIp(), "nacos_auto_migrate");
        }
    }

    public void checkMigrateTag(String dataId, String group, String tenant, String tag) {
        ConfigInfoTagWrapper configInfo4Tag = this.configInfoTagPersistService.findConfigInfo4Tag(dataId, group, tenant, tag);
        if (configInfo4Tag == null) {
            ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "tag_" + tag);
            if (configInfo4Gray == null) {
                return;
            }
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, tenant, "tag_" + tag, NetUtils.localIp(), "nacos_auto_migrate");
            return;
        }
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(dataId, group, tenant, "tag_" + tag);
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < configInfo4Tag.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate tag to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{configInfo4Tag.getDataId(), configInfo4Tag.getGroup(), configInfo4Tag.getTenant(), configInfo4Tag.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("tag", "1.0.0", configInfo4Tag.getTag(), 0x7FFFFFFE);
            this.configInfoGrayPersistService.insertOrUpdateGray(configInfo4Tag, "tag", GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIp(), "nacos_auto_migrate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkChangedConfigGrayMigrateState(ConfigInfoGrayWrapper changedConfigInfoGrayWrapper) {
        String tenant = changedConfigInfoGrayWrapper.getTenant();
        if (!ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        if (!StringUtils.equals((String)tenant, (String)"public") && StringUtils.isNotBlank((String)tenant)) {
            return;
        }
        String targetTenant = "";
        if (StringUtils.isBlank((CharSequence)tenant)) {
            targetTenant = "public";
        }
        ConfigInfoGrayWrapper targetConfigInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(changedConfigInfoGrayWrapper.getDataId(), changedConfigInfoGrayWrapper.getGroup(), targetTenant, changedConfigInfoGrayWrapper.getGrayName());
        try {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
            if (StringUtils.equals((String)changedConfigInfoGrayWrapper.getSrcUser(), (String)NAMESPACE_MIGRATE_SRC_USER)) {
                if (targetConfigInfoGrayWrapper == null) {
                    this.configInfoGrayPersistService.removeConfigInfoGray(changedConfigInfoGrayWrapper.getDataId(), changedConfigInfoGrayWrapper.getGroup(), tenant, changedConfigInfoGrayWrapper.getGrayName(), null, NAMESPACE_MIGRATE_SRC_USER);
                } else if (!(targetConfigInfoGrayWrapper.getMd5().equals(changedConfigInfoGrayWrapper.getMd5()) && !targetConfigInfoGrayWrapper.getGrayRule().equals(changedConfigInfoGrayWrapper.getGrayRule()) || targetConfigInfoGrayWrapper.getLastModified() < changedConfigInfoGrayWrapper.getLastModified() && StringUtils.equals((String)targetConfigInfoGrayWrapper.getSrcUser(), (String)NAMESPACE_MIGRATE_SRC_USER))) {
                    targetConfigInfoGrayWrapper.setTenant(tenant);
                    this.configInfoGrayPersistService.updateConfigInfo4Gray(targetConfigInfoGrayWrapper, targetConfigInfoGrayWrapper.getGrayName(), targetConfigInfoGrayWrapper.getGrayRule(), null, NAMESPACE_MIGRATE_SRC_USER);
                }
            } else if (targetConfigInfoGrayWrapper == null) {
                changedConfigInfoGrayWrapper.setTenant(targetTenant);
                this.configInfoGrayPersistService.addConfigInfo4Gray(changedConfigInfoGrayWrapper, changedConfigInfoGrayWrapper.getGrayName(), changedConfigInfoGrayWrapper.getGrayRule(), null, NAMESPACE_MIGRATE_SRC_USER);
            } else if (!targetConfigInfoGrayWrapper.getMd5().equals(changedConfigInfoGrayWrapper.getMd5()) || targetConfigInfoGrayWrapper.getGrayRule().equals(changedConfigInfoGrayWrapper.getGrayRule())) {
                if (targetConfigInfoGrayWrapper.getLastModified() >= changedConfigInfoGrayWrapper.getLastModified() && !StringUtils.equals((String)targetConfigInfoGrayWrapper.getSrcUser(), (String)NAMESPACE_MIGRATE_SRC_USER)) {
                    targetConfigInfoGrayWrapper.setTenant(tenant);
                    this.configInfoGrayPersistService.updateConfigInfo4Gray(targetConfigInfoGrayWrapper, targetConfigInfoGrayWrapper.getGrayName(), targetConfigInfoGrayWrapper.getGrayRule(), null, NAMESPACE_MIGRATE_SRC_USER);
                } else if (targetConfigInfoGrayWrapper.getLastModified() < changedConfigInfoGrayWrapper.getLastModified()) {
                    changedConfigInfoGrayWrapper.setTenant(targetTenant);
                    this.configInfoGrayPersistService.updateConfigInfo4Gray(changedConfigInfoGrayWrapper, changedConfigInfoGrayWrapper.getGrayName(), changedConfigInfoGrayWrapper.getGrayRule(), null, NAMESPACE_MIGRATE_SRC_USER);
                }
            }
        }
        finally {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkChangedConfigMigrateState(ConfigInfoStateWrapper changedConfigInfoStateWrapper) {
        String tenant = changedConfigInfoStateWrapper.getTenant();
        if (!ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        if (!StringUtils.equals((String)tenant, (String)"public") && StringUtils.isNotBlank((String)tenant)) {
            return;
        }
        String targetTenant = "";
        if (StringUtils.isBlank((CharSequence)tenant)) {
            targetTenant = "public";
        }
        ConfigAllInfo changedConfigAllInfo = this.configInfoPersistService.findConfigAllInfo(changedConfigInfoStateWrapper.getDataId(), changedConfigInfoStateWrapper.getGroup(), tenant);
        ConfigAllInfo targetConfigAllInfo = this.configInfoPersistService.findConfigAllInfo(changedConfigInfoStateWrapper.getDataId(), changedConfigInfoStateWrapper.getGroup(), targetTenant);
        try {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(true);
            if (changedConfigAllInfo.getCreateUser().equals(NAMESPACE_MIGRATE_SRC_USER)) {
                if (targetConfigAllInfo == null) {
                    this.configInfoPersistService.removeConfigInfo(changedConfigAllInfo.getDataId(), changedConfigAllInfo.getGroup(), tenant, null, NAMESPACE_MIGRATE_SRC_USER);
                } else if (!(targetConfigAllInfo.getMd5().equals(changedConfigAllInfo.getMd5()) || targetConfigAllInfo.getModifyTime() < changedConfigAllInfo.getModifyTime() && StringUtils.equals((String)targetConfigAllInfo.getCreateUser(), (String)NAMESPACE_MIGRATE_SRC_USER))) {
                    targetConfigAllInfo.setTenant(tenant);
                    this.configInfoPersistService.updateConfigInfo(targetConfigAllInfo, null, NAMESPACE_MIGRATE_SRC_USER, null);
                }
            } else if (targetConfigAllInfo == null) {
                changedConfigAllInfo.setTenant(targetTenant);
                this.configInfoPersistService.addConfigInfo(null, NAMESPACE_MIGRATE_SRC_USER, changedConfigAllInfo, null);
            } else if (!targetConfigAllInfo.getMd5().equals(changedConfigAllInfo.getMd5())) {
                if (targetConfigAllInfo.getModifyTime() >= changedConfigAllInfo.getModifyTime() && !StringUtils.equals((String)targetConfigAllInfo.getCreateUser(), (String)NAMESPACE_MIGRATE_SRC_USER)) {
                    targetConfigAllInfo.setTenant(tenant);
                    this.configInfoPersistService.updateConfigInfo(targetConfigAllInfo, null, NAMESPACE_MIGRATE_SRC_USER, null);
                } else if (targetConfigAllInfo.getModifyTime() < changedConfigAllInfo.getModifyTime()) {
                    changedConfigAllInfo.setTenant(targetTenant);
                    this.configInfoPersistService.updateConfigInfo(changedConfigAllInfo, null, NAMESPACE_MIGRATE_SRC_USER, null);
                }
            }
        }
        finally {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDeletedConfigGrayMigrateState(ConfigInfoStateWrapper deletedConfigInfoGrayStateWrapper) {
        ConfigInfoStateWrapper targetConfigInfoGrayStateWrapper;
        String tenant = deletedConfigInfoGrayStateWrapper.getTenant();
        if (!ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        if (!StringUtils.equals((String)tenant, (String)"public") && StringUtils.isNotBlank((String)tenant)) {
            return;
        }
        String targetTenant = "";
        if (StringUtils.isBlank((CharSequence)tenant)) {
            targetTenant = "public";
        }
        if ((targetConfigInfoGrayStateWrapper = this.configInfoGrayPersistService.findConfigInfo4GrayState(deletedConfigInfoGrayStateWrapper.getDataId(), deletedConfigInfoGrayStateWrapper.getGroup(), deletedConfigInfoGrayStateWrapper.getGrayName(), targetTenant)) == null) {
            return;
        }
        try {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
            if (targetConfigInfoGrayStateWrapper.getLastModified() <= deletedConfigInfoGrayStateWrapper.getLastModified()) {
                this.configInfoGrayPersistService.removeConfigInfoGray(deletedConfigInfoGrayStateWrapper.getDataId(), deletedConfigInfoGrayStateWrapper.getGroup(), targetTenant, deletedConfigInfoGrayStateWrapper.getGrayName(), null, NAMESPACE_MIGRATE_SRC_USER);
            }
        }
        finally {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDeletedConfigMigrateState(ConfigInfoStateWrapper deletedConfigInfoStateWrapper) {
        ConfigInfoStateWrapper targetConfigInfoStateWrapper;
        String tenant = deletedConfigInfoStateWrapper.getTenant();
        if (!ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        if (!StringUtils.equals((String)tenant, (String)"public") && StringUtils.isNotBlank((String)tenant)) {
            return;
        }
        String targetTenant = "";
        if (StringUtils.isBlank((CharSequence)tenant)) {
            targetTenant = "public";
        }
        if ((targetConfigInfoStateWrapper = this.configInfoPersistService.findConfigInfoState(deletedConfigInfoStateWrapper.getDataId(), deletedConfigInfoStateWrapper.getGroup(), targetTenant)) == null) {
            return;
        }
        try {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(true);
            if (targetConfigInfoStateWrapper.getLastModified() <= deletedConfigInfoStateWrapper.getLastModified()) {
                this.configInfoPersistService.removeConfigInfo(deletedConfigInfoStateWrapper.getDataId(), deletedConfigInfoStateWrapper.getGroup(), targetTenant, null, NAMESPACE_MIGRATE_SRC_USER);
            }
        }
        finally {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doCheckNamespaceMigrate() throws Exception {
        void var27_44;
        void var16_21;
        long startTime = System.currentTimeMillis();
        int maxNamespaceMigrateRetryTimes = (Integer)EnvUtil.getProperty((String)"nacos.namespace.migrate.retry.times", Integer.class, (Object)3);
        this.namespaceMigratePreCheck(maxNamespaceMigrateRetryTimes);
        int batchSize = (Integer)EnvUtil.getProperty((String)"nacos.namespace.migrate.batch.size", Integer.class, (Object)100);
        long startId = -1L;
        List<Object> batchIds = new ArrayList();
        int totalInsertNums = 0;
        LOGGER.info("[migrate] start migrate config namespace");
        do {
            boolean migrateSuccess = false;
            for (int retryTimes = 0; retryTimes <= maxNamespaceMigrateRetryTimes; ++retryTimes) {
                try {
                    batchIds = this.configMigratePersistService.getMigrateConfigInsertIdList(startId, batchSize);
                    if (!batchIds.isEmpty()) {
                        this.configMigratePersistService.migrateConfigInsertByIds(batchIds, NAMESPACE_MIGRATE_SRC_USER);
                        startId = (Long)batchIds.get(batchIds.size() - 1);
                    }
                    migrateSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] config_info namespace migrate insert failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (!migrateSuccess) {
                LOGGER.error("[migrate] config_info namespace migrate insert failed");
                throw new Exception("[migrate] config_info namespace migrate insert failed");
            }
            LOGGER.info("[migrate] migrating config namespace from empty to public, finished:" + (totalInsertNums += batchIds.size()));
        } while (batchIds.size() == batchSize);
        long startEmptyId = -1L;
        int totalUpdateFromEmptyNums = 0;
        List<Object> batchConfigInfosFromEmpty = new ArrayList();
        do {
            boolean migrateSuccess = false;
            for (int retryTimes = 0; retryTimes <= maxNamespaceMigrateRetryTimes; ++retryTimes) {
                try {
                    batchConfigInfosFromEmpty = this.configMigratePersistService.getMigrateConfigUpdateList(startEmptyId, batchSize, "", "public", NAMESPACE_MIGRATE_SRC_USER);
                    if (!batchConfigInfosFromEmpty.isEmpty()) {
                        for (ConfigInfo configInfo : batchConfigInfosFromEmpty) {
                            this.configMigratePersistService.syncConfig(configInfo.getDataId(), configInfo.getGroup(), "", "public", NAMESPACE_MIGRATE_SRC_USER);
                        }
                        startEmptyId = ((ConfigInfo)batchConfigInfosFromEmpty.get(batchConfigInfosFromEmpty.size() - 1)).getId();
                    }
                    migrateSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] config_info namespace migrate update from empty failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (!migrateSuccess) {
                LOGGER.error("[migrate] config_info namespace migrate update from empty failed, skipped");
                if (!batchConfigInfosFromEmpty.isEmpty()) {
                    startEmptyId = ((ConfigInfo)batchConfigInfosFromEmpty.get(batchConfigInfosFromEmpty.size() - 1)).getId();
                }
            } else {
                totalUpdateFromEmptyNums += batchConfigInfosFromEmpty.size();
            }
            LOGGER.info("[migrate] syncing config namespace from empty to public, finished:" + totalUpdateFromEmptyNums);
        } while (batchConfigInfosFromEmpty.size() == batchSize);
        long startPublicId = -1L;
        int totalUpdateFromPublicNums = 0;
        ArrayList arrayList = new ArrayList();
        do {
            boolean migrateSuccess = false;
            for (int retryTimes = 0; retryTimes <= maxNamespaceMigrateRetryTimes; ++retryTimes) {
                try {
                    List<ConfigInfo> list = this.configMigratePersistService.getMigrateConfigUpdateList(startPublicId, batchSize, "public", "", NAMESPACE_MIGRATE_SRC_USER);
                    if (!list.isEmpty()) {
                        for (ConfigInfo configInfo : list) {
                            this.configMigratePersistService.syncConfig(configInfo.getDataId(), configInfo.getGroup(), "public", "", NAMESPACE_MIGRATE_SRC_USER);
                        }
                        startPublicId = list.get(list.size() - 1).getId();
                    }
                    migrateSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] config_info namespace migrate update from public failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (!migrateSuccess) {
                LOGGER.error("[migrate] config_info namespace migrate update from public failed, skipped");
                if (!var16_21.isEmpty()) {
                    startPublicId = ((ConfigInfo)var16_21.get(var16_21.size() - 1)).getId();
                }
            } else {
                totalUpdateFromPublicNums += var16_21.size();
            }
            LOGGER.info("[migrate] syncing config namespace from public to empty, finished:" + totalUpdateFromPublicNums);
        } while (var16_21.size() == batchSize);
        long startGrayId = -1L;
        int totalInsertGrayNum = 0;
        do {
            boolean migrateSuccess = false;
            for (int i = 0; i <= maxNamespaceMigrateRetryTimes; ++i) {
                try {
                    batchIds = this.configMigratePersistService.getMigrateConfigGrayInsertIdList(startGrayId, batchSize);
                    if (!batchIds.isEmpty()) {
                        this.configMigratePersistService.migrateConfigGrayInsertByIds(batchIds, NAMESPACE_MIGRATE_SRC_USER);
                        startGrayId = (Long)batchIds.get(batchIds.size() - 1);
                    }
                    migrateSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] config_info gray namespace migrate insert failed, retry times={}, error={}", (Object)i, (Object)e.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (!migrateSuccess) {
                LOGGER.error("[migrate] config_info_gray namespace migrate insert failed");
                throw new Exception("[migrate] config_info_gray namespace migrate insert failed");
            }
            LOGGER.info("[migrate] migrating config gray namespace from empty to public, finished:" + (totalInsertGrayNum += batchIds.size()));
        } while (batchIds.size() == batchSize);
        long l = -1L;
        int totalUpdateGrayFromEmptyNum = 0;
        List<Object> batchConfigInfoGraysFromEmpty = new ArrayList();
        do {
            boolean migrateSuccess = false;
            for (int retryTimes = 0; retryTimes <= maxNamespaceMigrateRetryTimes; ++retryTimes) {
                try {
                    batchConfigInfoGraysFromEmpty = this.configMigratePersistService.getMigrateConfigGrayUpdateList(l, batchSize, "", "public", NAMESPACE_MIGRATE_SRC_USER);
                    if (!batchConfigInfoGraysFromEmpty.isEmpty()) {
                        for (ConfigInfoGrayWrapper configInfoGrayWrapper : batchConfigInfoGraysFromEmpty) {
                            this.configMigratePersistService.syncConfigGray(configInfoGrayWrapper.getDataId(), configInfoGrayWrapper.getGroup(), "", configInfoGrayWrapper.getGrayName(), "public", NAMESPACE_MIGRATE_SRC_USER);
                        }
                        l = ((ConfigInfoGrayWrapper)batchConfigInfoGraysFromEmpty.get(batchConfigInfoGraysFromEmpty.size() - 1)).getId();
                    }
                    migrateSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] config_info_gray namespace migrate update from empty failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (!migrateSuccess) {
                LOGGER.error("[migrate] config_info_gray namespace migrate update from empty failed, skipped");
                if (!batchConfigInfoGraysFromEmpty.isEmpty()) {
                    l = ((ConfigInfoGrayWrapper)batchConfigInfoGraysFromEmpty.get(batchConfigInfoGraysFromEmpty.size() - 1)).getId();
                }
            } else {
                totalUpdateGrayFromEmptyNum += batchConfigInfoGraysFromEmpty.size();
            }
            LOGGER.info("[migrate] syncing config gray namespace from empty to public, finished:" + totalUpdateGrayFromEmptyNum);
        } while (batchConfigInfoGraysFromEmpty.size() == batchSize);
        long startGrayPublicId = -1L;
        int totalUpdateGrayFromPublicNum = 0;
        ArrayList arrayList2 = new ArrayList();
        do {
            boolean migrateSuccess = false;
            for (int retryTimes = 0; retryTimes <= maxNamespaceMigrateRetryTimes; ++retryTimes) {
                try {
                    List<ConfigInfoGrayWrapper> list = this.configMigratePersistService.getMigrateConfigGrayUpdateList(startGrayPublicId, batchSize, "public", "", NAMESPACE_MIGRATE_SRC_USER);
                    if (!list.isEmpty()) {
                        for (ConfigInfoGrayWrapper configInfoGrayWrapper : list) {
                            this.configMigratePersistService.syncConfigGray(configInfoGrayWrapper.getDataId(), configInfoGrayWrapper.getGroup(), "public", configInfoGrayWrapper.getGrayName(), "", NAMESPACE_MIGRATE_SRC_USER);
                        }
                        startGrayPublicId = list.get(list.size() - 1).getId();
                    }
                    migrateSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] config_info_gray namespace migrate update from public failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
            if (!migrateSuccess) {
                LOGGER.error("[migrate] config_info_gray namespace migrate update from public failed, skipped");
                if (!var27_44.isEmpty()) {
                    startGrayPublicId = ((ConfigInfoGrayWrapper)var27_44.get(var27_44.size() - 1)).getId();
                }
            } else {
                totalUpdateGrayFromPublicNum += var27_44.size();
            }
            LOGGER.info("[migrate] syncing config gray namespace from public to empty, finished:" + totalUpdateGrayFromPublicNum);
        } while (var27_44.size() == batchSize);
        LOGGER.info("[migrate] finish migrate config namespacetotal time taken: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void namespaceMigratePreCheck(int maxRetryTimes) throws Exception {
        int conflictCount;
        int retryTimes;
        boolean checkSuccess = false;
        for (retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
            block10: {
                try {
                    conflictCount = this.configMigratePersistService.configInfoConflictCount(NAMESPACE_MIGRATE_SRC_USER);
                    if (conflictCount > 0) {
                        LOGGER.error("[migrate] config_info conflict count=" + conflictCount);
                        break block10;
                    }
                    checkSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] namespace migrate pre check failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                }
            }
            Thread.sleep(1000L);
        }
        if (!checkSuccess) {
            throw new Exception("[migrate] config_info namespace migrate pre check failed");
        }
        checkSuccess = false;
        for (retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
            block11: {
                try {
                    conflictCount = this.configMigratePersistService.configInfoGrayConflictCount(NAMESPACE_MIGRATE_SRC_USER);
                    if (conflictCount > 0) {
                        LOGGER.error("[migrate] config_info_gray conflict count=" + conflictCount);
                        break block11;
                    }
                    checkSuccess = true;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("[migrate] namespace migrate pre check failed, retry times={}, error={}", (Object)retryTimes, (Object)e.getMessage());
                }
            }
            Thread.sleep(1000L);
        }
        if (!checkSuccess) {
            throw new Exception("[migrate] config_gray namespace migrate pre check failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void namespaceMigrateGray(String dataId, String group, String tenant, String grayName) {
        try {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
            if (StringUtils.isBlank((CharSequence)tenant)) {
                this.configMigratePersistService.syncConfigGray(dataId, group, tenant, grayName, "public", NAMESPACE_MIGRATE_SRC_USER);
            } else if (StringUtils.equals((String)tenant, (String)"public")) {
                this.configMigratePersistService.syncConfigGray(dataId, group, tenant, grayName, "", NAMESPACE_MIGRATE_SRC_USER);
            }
        }
        catch (Exception e) {
            LOGGER.error("[migrate] namespace migrate gray failed", (Throwable)e);
        }
        finally {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void namespaceMigrate(String dataId, String group, String tenant) {
        try {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(true);
            if (StringUtils.isBlank((CharSequence)tenant)) {
                this.configMigratePersistService.syncConfig(dataId, group, tenant, "public", NAMESPACE_MIGRATE_SRC_USER);
            } else if (StringUtils.equals((String)tenant, (String)"public")) {
                this.configMigratePersistService.syncConfig(dataId, group, tenant, "", NAMESPACE_MIGRATE_SRC_USER);
            }
        }
        catch (Exception e) {
            LOGGER.error("[migrate] namespace migrate failed", (Throwable)e);
        }
        finally {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishConfigMigrate(ConfigForm configFormOrigin, ConfigRequestInfo configRequestInfo, String encryptedDataKey) throws NacosException {
        block10: {
            ConfigForm configForm = configFormOrigin.clone();
            if (!StringUtils.equals((String)configForm.getNamespaceId(), (String)"public") || !ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
                return;
            }
            ConfigInfoWrapper targetConfigInfoWrapper = this.configInfoPersistService.findConfigInfo(configForm.getDataId(), configForm.getGroup(), "");
            configForm.setNamespaceId("");
            configForm.setSrcUser(NAMESPACE_MIGRATE_SRC_USER);
            Map<String, Object> configAdvanceInfo = this.getConfigAdvanceInfo(configForm);
            ParamUtils.checkParam(configAdvanceInfo);
            configForm.setEncryptedDataKey(encryptedDataKey);
            ConfigInfo configInfo = new ConfigInfo(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getAppName(), configForm.getContent());
            if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
                configInfo.setMd5(configRequestInfo.getCasMd5());
            }
            configInfo.setType(configForm.getType());
            configInfo.setEncryptedDataKey(encryptedDataKey);
            try {
                PropertyUtil.CONFIG_MIGRATE_FLAG.set(true);
                if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
                    ConfigOperateResult configOperateResult = this.configInfoPersistService.insertOrUpdateCas(configRequestInfo.getSrcIp(), configForm.getSrcUser(), configInfo, configAdvanceInfo);
                    if (!configOperateResult.isSuccess()) {
                        LOGGER.warn("[cas-publish-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5()});
                        throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish fail, server md5 may have changed.");
                    }
                    break block10;
                }
                if (configRequestInfo.getUpdateForExist().booleanValue()) {
                    this.configInfoPersistService.insertOrUpdate(configRequestInfo.getSrcIp(), configForm.getSrcUser(), configInfo, configAdvanceInfo);
                    break block10;
                }
                try {
                    this.configInfoPersistService.addConfigInfo(configRequestInfo.getSrcIp(), configForm.getSrcUser(), configInfo, configAdvanceInfo);
                }
                catch (DataIntegrityViolationException ive) {
                    LOGGER.warn("[publish-config-failed] config already exists. dataId: {}, group: {}, namespaceId: {}", new Object[]{configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId()});
                    throw new ConfigAlreadyExistsException(String.format("config already exist, dataId: %s, group: %s, namespaceId: %s", configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId()));
                }
            }
            finally {
                PropertyUtil.CONFIG_MIGRATE_FLAG.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishConfigGrayMigrate(String grayType, ConfigForm configFormOrigin, ConfigRequestInfo configRequestInfo) throws NacosException {
        ConfigForm configForm = configFormOrigin.clone();
        if (!StringUtils.equals((String)configForm.getNamespaceId(), (String)"public") || !ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        ConfigInfoGrayWrapper targetConfigInfoGrayWrapper = this.configInfoGrayPersistService.findConfigInfo4Gray(configForm.getDataId(), configForm.getGroup(), "", configForm.getGrayName());
        configForm.setNamespaceId("");
        configForm.setSrcUser(NAMESPACE_MIGRATE_SRC_USER);
        Map<String, Object> configAdvanceInfo = this.getConfigAdvanceInfo(configForm);
        ParamUtils.checkParam(configAdvanceInfo);
        ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo(grayType, configForm.getGrayVersion(), configForm.getGrayRuleExp(), configForm.getGrayPriority());
        GrayRule grayRuleStruct = GrayRuleManager.constructGrayRule(localConfigGrayPersistInfo);
        if (grayRuleStruct == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.CONFIG_GRAY_VERSION_INVALID, ErrorCode.CONFIG_GRAY_VERSION_INVALID.getMsg());
        }
        if (!grayRuleStruct.isValid()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.CONFIG_GRAY_RULE_FORMAT_INVALID, ErrorCode.CONFIG_GRAY_RULE_FORMAT_INVALID.getMsg());
        }
        ConfigInfo configInfo = new ConfigInfo(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getAppName(), configForm.getContent());
        configInfo.setType(configForm.getType());
        configInfo.setEncryptedDataKey(configForm.getEncryptedDataKey());
        if (StringUtils.equals((String)grayType, (String)"tag")) {
            this.persistTagv1(configForm, configInfo, configRequestInfo);
        } else if (StringUtils.equals((String)grayType, (String)"beta")) {
            this.persistBeta(configForm, configInfo, configRequestInfo);
        }
        try {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
            if (StringUtils.isNotBlank((String)configRequestInfo.getCasMd5())) {
                ConfigOperateResult configOperateResult = this.configInfoGrayPersistService.insertOrUpdateGrayCas(configInfo, configForm.getGrayName(), GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), configRequestInfo.getSrcIp(), configForm.getSrcUser());
                if (!configOperateResult.isSuccess()) {
                    LOGGER.warn("[cas-publish-gray-config-fail] srcIp = {}, dataId= {}, casMd5 = {}, grayName = {}, msg = server md5 may have changed.", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configRequestInfo.getCasMd5(), configForm.getGrayName()});
                    throw new NacosApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), ErrorCode.RESOURCE_CONFLICT, "Cas publish gray config fail, server md5 may have changed.");
                }
            } else {
                this.configInfoGrayPersistService.insertOrUpdateGray(configInfo, configForm.getGrayName(), GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), configRequestInfo.getSrcIp(), configForm.getSrcUser());
            }
        }
        finally {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigInfoMigrate(String dataId, String group, String tenant, String srcIp, String srcUser) {
        if (!StringUtils.equals((String)tenant, (String)"public") || !ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        try {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(true);
            this.configInfoPersistService.removeConfigInfo(dataId, group, "", srcIp, NAMESPACE_MIGRATE_SRC_USER);
        }
        finally {
            PropertyUtil.CONFIG_MIGRATE_FLAG.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigInfoGrayMigrate(String dataId, String group, String tenant, String grayName, String srcIp, String srcUser) {
        if (!StringUtils.equals((String)tenant, (String)"public") || !ConfigCompatibleConfig.getInstance().isNamespaceCompatibleMode()) {
            return;
        }
        try {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
            this.configInfoGrayPersistService.removeConfigInfoGray(dataId, group, "", grayName, srcIp, NAMESPACE_MIGRATE_SRC_USER);
            this.deleteConfigGrayV1(dataId, group, "", grayName, srcIp, NAMESPACE_MIGRATE_SRC_USER);
        }
        finally {
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    public Map<String, Object> getConfigAdvanceInfo(ConfigForm configForm) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"config_tags", (Object)configForm.getConfigTags());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"desc", (Object)configForm.getDesc());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"use", (Object)configForm.getUse());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"effect", (Object)configForm.getEffect());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"type", (Object)configForm.getType());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"schema", (Object)configForm.getSchema());
        return configAdvanceInfo;
    }

    private void doCheckMigrate() throws Exception {
        int unfinishedTaskCount;
        Object page;
        int pageNo;
        int migrateMulti = (Integer)EnvUtil.getProperty((String)"nacos.gray.migrate.executor.multi", Integer.class, (Object)4);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(ThreadUtils.getSuitableThreadCount((int)migrateMulti), ThreadUtils.getSuitableThreadCount((int)migrateMulti), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(PropertyUtil.getAllDumpPageSize() * migrateMulti), r -> new Thread(r, "gray-migrate-worker"), new ThreadPoolExecutor.CallerRunsPolicy());
        int pageSize = 100;
        int rowCount = this.configInfoBetaPersistService.configInfoBetaCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
        int actualRowCount = 0;
        for (pageNo = 1; pageNo <= pageCount; ++pageNo) {
            page = this.configInfoBetaPersistService.findAllConfigInfoBetaForDumpAll(pageNo, pageSize);
            if (page == null) continue;
            for (ConfigInfo cf : page.getPageItems()) {
                executorService.execute(() -> this.lambda$doCheckMigrate$1((ConfigInfoBetaWrapper)cf));
            }
            LogUtil.DEFAULT_LOG.info("[gray-migrate-beta] submit gray task {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        try {
            unfinishedTaskCount = 0;
            while ((unfinishedTaskCount = executorService.getQueue().size() + executorService.getActiveCount()) > 0) {
                LogUtil.DEFAULT_LOG.info("[gray-migrate-beta] wait {} migrate tasks to be finished", (Object)unfinishedTaskCount);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.error("[gray-migrate-beta] wait  dump tasks to be finished error", (Throwable)e);
            throw e;
        }
        rowCount = this.configInfoTagPersistService.configInfoTagCount();
        pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
        actualRowCount = 0;
        for (pageNo = 1; pageNo <= pageCount; ++pageNo) {
            page = this.configInfoTagPersistService.findAllConfigInfoTagForDumpAll(pageNo, pageSize);
            if (page == null) continue;
            for (ConfigInfo cf : page.getPageItems()) {
                executorService.execute(() -> this.lambda$doCheckMigrate$2((ConfigInfoTagWrapper)cf));
            }
            LogUtil.DEFAULT_LOG.info("[gray-migrate-tag]  submit gray task  {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        try {
            unfinishedTaskCount = 0;
            while ((unfinishedTaskCount = executorService.getQueue().size() + executorService.getActiveCount()) > 0) {
                LogUtil.DEFAULT_LOG.info("[gray-migrate-tag] wait {} migrate tasks to be finished", (Object)unfinishedTaskCount);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.error("[gray-migrate-tag] wait migrate tasks to be finished error", (Throwable)e);
            throw e;
        }
        executorService.shutdown();
    }

    private /* synthetic */ void lambda$doCheckMigrate$2(ConfigInfoTagWrapper cf) {
        PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(cf.getDataId(), cf.getGroup(), cf.getTenant(), "tag_" + cf.getTag());
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < cf.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate tag to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("tag", "1.0.0", cf.getTag(), 0x7FFFFFFE);
            this.configInfoGrayPersistService.insertOrUpdateGray(cf, "tag_" + cf.getTag(), GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIp(), "nacos_auto_migrate");
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }

    private /* synthetic */ void lambda$doCheckMigrate$1(ConfigInfoBetaWrapper cf) {
        PropertyUtil.GRAY_MIGRATE_FLAG.set(true);
        ConfigInfoGrayWrapper configInfo4Gray = this.configInfoGrayPersistService.findConfigInfo4Gray(cf.getDataId(), cf.getGroup(), cf.getTenant(), "beta");
        if (configInfo4Gray == null || configInfo4Gray.getLastModified() < cf.getLastModified()) {
            LogUtil.DEFAULT_LOG.info("[migrate beta to gray] dataId={}, group={}, tenant={},  md5={}", new Object[]{cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getMd5()});
            ConfigGrayPersistInfo localConfigGrayPersistInfo = new ConfigGrayPersistInfo("beta", "1.0.0", cf.getBetaIps(), Integer.MAX_VALUE);
            this.configInfoGrayPersistService.insertOrUpdateGray(cf, "beta", GrayRuleManager.serializeConfigGrayPersistInfo(localConfigGrayPersistInfo), NetUtils.localIp(), "nacos_auto_migrate");
            PropertyUtil.GRAY_MIGRATE_FLAG.set(false);
        }
    }
}

