/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchChangeNotifyRequest;
import com.alibaba.nacos.api.remote.AbstractPushCallBack;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.api.remote.request.ServerRequest;
import com.alibaba.nacos.config.server.configuration.ConfigCommonConfig;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RpcPushService;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class FuzzyWatchChangeNotifyTask
implements Runnable {
    private static final String POINT_FUZZY_WATCH_CONFIG_PUSH = "POINT_FUZZY_WATCH_CONFIG_PUSH";
    private static final String POINT_FUZZY_WATCH_CONFIG_PUSH_SUCCESS = "POINT_FUZZY_WATCH_CONFIG_PUSH_SUCCESS";
    private static final String POINT_FUZZY_WATCH_CONFIG_PUSH_FAIL = "POINT_FUZZY_WATCH_CONFIG_PUSH_FAIL";
    ConfigFuzzyWatchChangeNotifyRequest notifyRequest;
    final ConnectionManager connectionManager;
    final RpcPushService rpcPushService;
    int maxRetryTimes;
    int tryTimes = 0;
    String connectionId;

    public FuzzyWatchChangeNotifyTask(ConnectionManager connectionManager, RpcPushService rpcPushService, ConfigFuzzyWatchChangeNotifyRequest notifyRequest, int maxRetryTimes, String connectionId) {
        this.connectionManager = connectionManager;
        this.rpcPushService = rpcPushService;
        this.notifyRequest = notifyRequest;
        this.maxRetryTimes = maxRetryTimes;
        this.connectionId = connectionId;
    }

    public boolean isOverTimes() {
        return this.maxRetryTimes > 0 && this.tryTimes >= this.maxRetryTimes;
    }

    @Override
    public void run() {
        if (this.isOverTimes()) {
            Loggers.REMOTE_PUSH.warn("push callback retry fail over times.groupKey={},,clientId={}, will unregister client.", (Object)this.notifyRequest.getGroupKey(), (Object)this.connectionId);
            this.connectionManager.unregister(this.connectionId);
        } else if (this.connectionManager.getConnection(this.connectionId) == null) {
            Loggers.REMOTE_PUSH.warn("Client is already offline, ignore the task. dataId={},groupKey={},tenant={},clientId={}", (Object)this.notifyRequest.getGroupKey(), (Object)this.connectionId);
            return;
        }
        TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
        tpsCheckRequest.setPointName(POINT_FUZZY_WATCH_CONFIG_PUSH);
        if (!ControlManagerCenter.getInstance().getTpsControlManager().check(tpsCheckRequest).isSuccess()) {
            this.scheduleSelf();
        } else {
            long timeout = ConfigCommonConfig.getInstance().getPushTimeout();
            this.rpcPushService.pushWithCallback(this.connectionId, (ServerRequest)this.notifyRequest, (PushCallBack)new AbstractPushCallBack(timeout){

                public void onSuccess() {
                    TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
                    tpsCheckRequest.setPointName(FuzzyWatchChangeNotifyTask.POINT_FUZZY_WATCH_CONFIG_PUSH_SUCCESS);
                    ControlManagerCenter.getInstance().getTpsControlManager().check(tpsCheckRequest);
                }

                public void onFail(Throwable e) {
                    TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
                    tpsCheckRequest.setPointName(FuzzyWatchChangeNotifyTask.POINT_FUZZY_WATCH_CONFIG_PUSH_FAIL);
                    ControlManagerCenter.getInstance().getTpsControlManager().check(tpsCheckRequest);
                    Loggers.REMOTE_PUSH.warn("Push fail,  groupKey={},  clientId={}", new Object[]{FuzzyWatchChangeNotifyTask.this.notifyRequest.getGroupKey(), FuzzyWatchChangeNotifyTask.this.connectionId, e});
                    FuzzyWatchChangeNotifyTask.this.scheduleSelf();
                }
            }, (Executor)ConfigExecutor.getClientConfigNotifierServiceExecutor());
        }
    }

    void scheduleSelf() {
        ConfigExecutor.scheduleClientConfigNotifier(this, (long)this.tryTimes * 2L, TimeUnit.SECONDS);
    }
}

