/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.ConfigListenState;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ConfigChangeListenContext {
    private ConcurrentHashMap<String, HashSet<String>> groupKeyContext = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HashMap<String, ConfigListenState>> connectionIdContext = new ConcurrentHashMap();

    public synchronized void addListen(String groupKey, String md5, String connectionId, boolean isNamespaceTransfer) {
        this.groupKeyContext.computeIfAbsent(groupKey, k -> new HashSet()).add(connectionId);
        ConfigListenState listenState = new ConfigListenState(md5);
        listenState.setNamespaceTransfer(isNamespaceTransfer);
        this.connectionIdContext.computeIfAbsent(connectionId, k -> new HashMap(16)).put(groupKey, listenState);
    }

    public synchronized void removeListen(String groupKey, String connectionId) {
        HashMap<String, ConfigListenState> groupKeys;
        Set connectionIds = this.groupKeyContext.get(groupKey);
        if (connectionIds != null) {
            connectionIds.remove(connectionId);
            if (connectionIds.isEmpty()) {
                this.groupKeyContext.remove(groupKey);
            }
        }
        if ((groupKeys = this.connectionIdContext.get(connectionId)) != null) {
            groupKeys.remove(groupKey);
        }
    }

    public synchronized Set<String> getListeners(String groupKey) {
        HashSet<String> strings = this.groupKeyContext.get(groupKey);
        if (CollectionUtils.isNotEmpty(strings)) {
            HashSet<String> listenConnections = new HashSet<String>();
            this.safeCopy(strings, listenConnections);
            return listenConnections;
        }
        return null;
    }

    private void safeCopy(Collection src, Collection dest) {
        Iterator iterator = src.iterator();
        while (iterator.hasNext()) {
            dest.add(iterator.next());
        }
    }

    public synchronized void clearContextForConnectionId(String connectionId) {
        Map<String, String> listenKeys = this.getListenKeys(connectionId);
        if (listenKeys == null) {
            this.connectionIdContext.remove(connectionId);
            return;
        }
        for (Map.Entry<String, String> groupKey : listenKeys.entrySet()) {
            Set connectionIds = this.groupKeyContext.get(groupKey.getKey());
            if (CollectionUtils.isNotEmpty((Collection)connectionIds)) {
                connectionIds.remove(connectionId);
                if (!connectionIds.isEmpty()) continue;
                this.groupKeyContext.remove(groupKey.getKey());
                continue;
            }
            this.groupKeyContext.remove(groupKey.getKey());
        }
        this.connectionIdContext.remove(connectionId);
    }

    public synchronized Map<String, String> getListenKeys(String connectionId) {
        HashMap<String, ConfigListenState> stringStringHashMap = this.connectionIdContext.get(connectionId);
        if (stringStringHashMap != null) {
            HashMap<String, String> md5Map = new HashMap<String, String>(stringStringHashMap.size());
            for (Map.Entry<String, ConfigListenState> entry : stringStringHashMap.entrySet()) {
                md5Map.put(entry.getKey(), entry.getValue().getMd5());
            }
            return md5Map;
        }
        return null;
    }

    public String getListenKeyMd5(String connectionId, String groupKey) {
        Map groupKeyContexts = this.connectionIdContext.get(connectionId);
        return groupKeyContexts == null ? null : ((ConfigListenState)groupKeyContexts.get(groupKey)).getMd5();
    }

    public ConfigListenState getConfigListenState(String connectionId, String groupKey) {
        Map groupKeyContexts = this.connectionIdContext.get(connectionId);
        return groupKeyContexts == null ? null : (ConfigListenState)groupKeyContexts.get(groupKey);
    }

    public synchronized HashMap<String, ConfigListenState> getConfigListenStates(String connectionId) {
        HashMap<String, ConfigListenState> configListenStateHashMap = this.connectionIdContext.get(connectionId);
        return configListenStateHashMap == null ? null : new HashMap<String, ConfigListenState>(configListenStateHashMap);
    }

    public int getConnectionCount() {
        return this.connectionIdContext.size();
    }
}

