/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.monitor;

import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.monitor.PrintGetConfigResponeTask;
import com.alibaba.nacos.config.server.monitor.PrintMemoryTask;
import com.alibaba.nacos.config.server.monitor.ThreadTaskQueueMonitorTask;
import com.alibaba.nacos.config.server.service.notify.AsyncNotifyService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class MemoryMonitor {
    private static final long DELAY_SECONDS = 10L;

    @Autowired
    public MemoryMonitor(AsyncNotifyService notifySingleService) {
        ConfigExecutor.scheduleConfigTask(new PrintMemoryTask(), 10L, 10L, TimeUnit.SECONDS);
        ConfigExecutor.scheduleConfigTask(new PrintGetConfigResponeTask(), 10L, 10L, TimeUnit.SECONDS);
        ConfigExecutor.scheduleConfigTask(new ThreadTaskQueueMonitorTask(notifySingleService), 10L, 10L, TimeUnit.SECONDS);
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void clear() {
        MetricsMonitor.getConfigMonitor().set(0);
        MetricsMonitor.getPublishMonitor().set(0);
        MetricsMonitor.getFuzzySearchMonitor().set(0);
    }
}

