/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model.form;

import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.NacosForm;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.capacity.CapacityService;
import org.springframework.http.HttpStatus;

public class UpdateCapacityForm
implements NacosForm {
    private static final long serialVersionUID = -1912905276914026856L;
    private String groupName;
    private String namespaceId;
    private Integer quota;
    private Integer maxSize;
    private Integer maxAggrCount;
    private Integer maxAggrSize;

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public Integer getQuota() {
        return this.quota;
    }

    public void setQuota(Integer quota) {
        this.quota = quota;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Integer getMaxAggrCount() {
        return this.maxAggrCount;
    }

    public void setMaxAggrCount(Integer maxAggrCount) {
        this.maxAggrCount = maxAggrCount;
    }

    public Integer getMaxAggrSize() {
        return this.maxAggrSize;
    }

    public void setMaxAggrSize(Integer maxAggrSize) {
        this.maxAggrSize = maxAggrSize;
    }

    public void validate() throws NacosApiException {
        if (this.quota == null && this.maxSize == null && this.maxAggrCount == null && this.maxAggrSize == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "The parameters quota, maxSize, maxAggrCount, maxAggrSize cannot be empty at the same time");
        }
    }

    public void checkNamespaceIdAndGroupName(CapacityService capacityService) throws NacosApiException {
        if (StringUtils.isBlank((CharSequence)this.groupName) && StringUtils.isBlank((CharSequence)this.namespaceId)) {
            capacityService.initAllCapacity();
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "At least one of the parameters (groupName or namespaceId) must be provided");
        }
    }
}

