/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConfigCommonConfig;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.persistence.configuration.DatasourceConfiguration;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.datasource.LocalDataSourceServiceImpl;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/cs/ops"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConfigOpsControllerV3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigOpsControllerV3.class);
    private final DumpService dumpService;

    public ConfigOpsControllerV3(DumpService dumpService) {
        this.dumpService = dumpService;
    }

    @PostMapping(value={"/localCache"})
    @Secured(resource="/v3/admin/cs/ops", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<String> updateLocalCacheFromStore() {
        LOGGER.info("start to dump all data from store.");
        try {
            this.dumpService.dumpAll();
            return Result.success((Object)"Local cache updated from store successfully!");
        }
        catch (Exception e) {
            LOGGER.error("[updateLocalCacheFromStore] ", (Throwable)e);
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)"Local cache updated from store failed!", (Object)e.getMessage());
        }
    }

    @PutMapping(value={"/log"})
    @Secured(resource="/v3/admin/cs/ops", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<String> setLogLevel(@RequestParam String logName, @RequestParam String logLevel) {
        try {
            LogUtil.setLogLevel(logName, logLevel);
            return Result.success((Object)String.format("Log level updated successfully! Module: %s, Log Level: %s", logName, logLevel));
        }
        catch (Exception e) {
            LOGGER.error("Failed to set log level for module {} to {}", new Object[]{logName, logLevel, e});
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)String.format("Failed to set log level for module %s to %s: %s", logName, logLevel, e.getMessage()), null);
        }
    }

    @GetMapping(value={"/derby"})
    @Secured(resource="/v3/admin/cs/ops", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Object> derbyOps(@RequestParam(value="sql") String sql) {
        String selectSign = "SELECT";
        String limitSign = "ROWS FETCH NEXT";
        String limit = " OFFSET 0 ROWS FETCH NEXT 1000 ROWS ONLY";
        try {
            if (!DatasourceConfiguration.isEmbeddedStorage()) {
                return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)"The current storage mode is not Derby", null);
            }
            if (!ConfigCommonConfig.getInstance().isDerbyOpsEnabled()) {
                return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)"Derby ops is disabled, please set `nacos.config.derby.ops.enabled=true` to enabled this feature.", null);
            }
            LocalDataSourceServiceImpl dataSourceService = (LocalDataSourceServiceImpl)DynamicDataSource.getInstance().getDataSource();
            if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)selectSign)) {
                if (!StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)limitSign)) {
                    sql = (String)sql + limit;
                }
                JdbcTemplate template = dataSourceService.getJdbcTemplate();
                List result = template.queryForList((String)sql);
                return Result.success((Object)result);
            }
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)"Only query statements are allowed to be executed", null);
        }
        catch (Exception e) {
            LOGGER.error("Derby failed to execute sql: " + (String)sql);
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)("Failed to execute sql: " + (String)sql), null);
        }
    }

    @PostMapping(value={"/derby/import"})
    @Secured(resource="/v3/admin/cs/ops", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public DeferredResult<Result<String>> importDerby(@RequestParam(value="file") MultipartFile multipartFile) {
        DeferredResult response = new DeferredResult();
        if (!DatasourceConfiguration.isEmbeddedStorage()) {
            response.setResult((Object)RestResultUtils.failed((String)"Limited to embedded storage mode"));
            return this.convertToResult((DeferredResult<RestResult<String>>)response);
        }
        if (!ConfigCommonConfig.getInstance().isDerbyOpsEnabled()) {
            response.setResult((Object)RestResultUtils.failed((String)"Derby ops is disabled, please set `nacos.config.derby.ops.enabled=true` to enabled this feature."));
            return this.convertToResult((DeferredResult<RestResult<String>>)response);
        }
        DatabaseOperate databaseOperate = (DatabaseOperate)ApplicationUtils.getBean(DatabaseOperate.class);
        WebUtils.onFileUpload((MultipartFile)multipartFile, file -> {
            NotifyCenter.publishEvent((Event)new DerbyImportEvent(false));
            databaseOperate.dataImport(file).whenComplete((result, ex) -> {
                NotifyCenter.publishEvent((Event)new DerbyImportEvent(true));
                if (Objects.nonNull(ex)) {
                    response.setResult((Object)RestResultUtils.failed((String)ex.getMessage()));
                    return;
                }
                response.setResult(result);
            });
        }, (DeferredResult)response);
        return this.convertToResult((DeferredResult<RestResult<String>>)response);
    }

    private DeferredResult<Result<String>> convertToResult(DeferredResult<RestResult<String>> restResult) {
        DeferredResult wrappedResponse = new DeferredResult();
        restResult.onCompletion(() -> {
            if (restResult.getResult() != null) {
                RestResult originalResult = (RestResult)restResult.getResult();
                Result newResult = new Result(Integer.valueOf(originalResult.getCode()), originalResult.getMessage(), (Object)((String)originalResult.getData()));
                wrappedResponse.setResult((Object)newResult);
            }
        });
        return wrappedResponse;
    }
}

