/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.remote.ConfigChangeListenContext;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/communication"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
@Deprecated
public class CommunicationController {
    private final LongPollingService longPollingService;
    private final ConfigChangeListenContext configChangeListenContext;
    private final ConnectionManager connectionManager;

    public CommunicationController(LongPollingService longPollingService, ConfigChangeListenContext configChangeListenContext, ConnectionManager connectionManager) {
        this.longPollingService = longPollingService;
        this.configChangeListenContext = configChangeListenContext;
        this.connectionManager = connectionManager;
    }

    @GetMapping(value={"/configWatchers"})
    @Compatibility(apiType=ApiType.INNER_API)
    @Secured(signType="config", apiType=ApiType.INNER_API)
    public SampleResult getSubClientConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, ModelMap modelMap) {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        SampleResult result = this.longPollingService.getCollectSubscribleInfo(dataId, group, tenant);
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        Set<String> listenersClients = this.configChangeListenContext.getListeners(groupKey);
        if (CollectionUtils.isEmpty(listenersClients)) {
            return result;
        }
        HashMap<String, String> listenersGroupkeyStatus = new HashMap<String, String>(listenersClients.size(), 1.0f);
        for (String connectionId : listenersClients) {
            String md5;
            Connection client = this.connectionManager.getConnection(connectionId);
            if (client == null || (md5 = this.configChangeListenContext.getListenKeyMd5(connectionId, groupKey)) == null) continue;
            listenersGroupkeyStatus.put(client.getMetaInfo().getClientIp(), md5);
        }
        result.getLisentersGroupkeyStatus().putAll(listenersGroupkeyStatus);
        return result;
    }

    @GetMapping(value={"/watcherConfigs"})
    @Compatibility(apiType=ApiType.INNER_API)
    @Secured(signType="config", apiType=ApiType.INNER_API)
    public SampleResult getSubClientConfigByIp(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ip") String ip, ModelMap modelMap) {
        SampleResult result = this.longPollingService.getCollectSubscribleInfoByIp(ip);
        List connectionsByIp = this.connectionManager.getConnectionByIp(ip);
        for (Connection connectionByIp : connectionsByIp) {
            Map<String, String> listenKeys = this.configChangeListenContext.getListenKeys(connectionByIp.getMetaInfo().getConnectionId());
            if (listenKeys == null) continue;
            result.getLisentersGroupkeyStatus().putAll(listenKeys);
        }
        return result;
    }
}

