/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.packagescan;

import com.alibaba.nacos.common.packagescan.PackageScan;
import com.alibaba.nacos.common.packagescan.classreading.ClassReader;
import com.alibaba.nacos.common.packagescan.resource.PathMatchingResourcePatternResolver;
import com.alibaba.nacos.common.packagescan.resource.Resource;
import com.alibaba.nacos.common.packagescan.util.NestedIoException;
import com.alibaba.nacos.common.utils.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageScan
implements PackageScan {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultPackageScan.class);
    private final PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    @Override
    public <T> Set<Class<T>> getSubTypesOf(String pkg, Class<T> requestClass) {
        HashSet<Class<T>> set = new HashSet<Class<T>>(16);
        String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + '/' + "**/*.class";
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                Class<?> scanClass = this.getClassByResource(resource);
                if (!requestClass.isAssignableFrom(scanClass)) continue;
                set.add(scanClass);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("scan path: {} failed", (Object)packageSearchPath, (Object)e);
        }
        return set;
    }

    @Override
    public <T> Set<Class<T>> getTypesAnnotatedWith(String pkg, Class<? extends Annotation> annotation) {
        HashSet<Class<T>> set = new HashSet<Class<T>>(16);
        String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + '/' + "**/*.class";
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                Class<?> scanClass = this.getClassByResource(resource);
                if (!scanClass.isAnnotationPresent(annotation)) continue;
                set.add(scanClass);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("scan path: {} failed", (Object)packageSearchPath, (Object)e);
        }
        return set;
    }

    private Class<?> getClassByResource(Resource resource) throws IOException, ClassNotFoundException {
        String className = DefaultPackageScan.getClassReader(resource).getClassName();
        return Class.forName(ClassUtils.resourcePathToConvertClassName(className));
    }

    private static ClassReader getClassReader(Resource resource) throws IOException {
        InputStream is = resource.getInputStream();
        try {
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        catch (IllegalArgumentException ex) {
            throw new NestedIoException("ASM ClassReader failed to parse class file - probably due to a new Java class file version that isn't supported yet: " + resource, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }
}

