/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.config;

import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NacosAuthConfigHolder {
    private static final NacosAuthConfigHolder INSTANCE = new NacosAuthConfigHolder();
    private final Map<String, NacosAuthConfig> nacosAuthConfigMap = new HashMap<String, NacosAuthConfig>();

    NacosAuthConfigHolder() {
        for (NacosAuthConfig each : NacosServiceLoader.load(NacosAuthConfig.class)) {
            this.nacosAuthConfigMap.put(each.getAuthScope(), each);
        }
    }

    public static NacosAuthConfigHolder getInstance() {
        return INSTANCE;
    }

    public NacosAuthConfig getNacosAuthConfigByScope(String scope) {
        return this.nacosAuthConfigMap.get(scope);
    }

    public Collection<NacosAuthConfig> getAllNacosAuthConfig() {
        return this.nacosAuthConfigMap.values();
    }

    public boolean isAnyAuthEnabled() {
        return this.nacosAuthConfigMap.values().stream().anyMatch(NacosAuthConfig::isAuthEnabled);
    }

    public boolean isAnyAuthEnabled(String ... scope) {
        for (String each : scope) {
            NacosAuthConfig config = this.nacosAuthConfigMap.get(each);
            if (null == config || !config.isAuthEnabled()) continue;
            return true;
        }
        return false;
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthConfigMap.values().stream().findFirst().map(NacosAuthConfig::getNacosAuthSystemType).orElse(null);
    }
}

