/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.servlet.jakarta;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.servlet.jakarta.MagicWebInterceptor;
import org.ssssssss.magicapi.utils.IpUtils;

public class WebIPLimitRequestInterceptor
implements MagicWebInterceptor {
    public static final String START_PLUGIN_LOG_MSG = "\u5df2\u5f00\u542f[{}],\u5982\u9700\u5173\u95ed[{}],\u63d2\u4ef6\u914d\u7f6e\u4fe1\u606f:[{}]";
    private static final Logger log = LoggerFactory.getLogger(WebIPLimitRequestInterceptor.class);
    private String whitelist;
    private String blacklist;

    @PostConstruct
    public void initIpLimitRequestInterceptor() {
        log.info(START_PLUGIN_LOG_MSG, new Object[]{"Web UI IP\u767d\u540d\u5355", "magic-api.api-iplimit.enable=false", "magic-api.api-iplimit.whitelist=ip\u5730\u5740\u9017\u53f7\u5206\u9694"});
    }

    private boolean isIpInBlacklist(String ip) {
        return this.blacklist != null && !this.blacklist.isEmpty() && this.blacklist.contains(ip);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean isAllow;
        String ip = IpUtils.getRealIP((String)request.getRemoteAddr(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0), null);
        if (ip == null) {
            return true;
        }
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            return true;
        }
        boolean bl = isAllow = !this.isIpInBlacklist(ip);
        if (this.whitelist != null && !this.whitelist.isEmpty() && !this.whitelist.contains(ip)) {
            isAllow = false;
        }
        if (!isAllow) {
            response.setStatus(403);
            response.setContentType("text/plain;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(String.format("\u5f53\u524dIP:[%s]\u65e0\u6743\u8bbf\u95ee\u8be5\u8d44\u6e90,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", ip));
            writer.flush();
            return false;
        }
        return true;
    }

    public String getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(String whitelist) {
        this.whitelist = whitelist;
    }

    public String getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(String blacklist) {
        this.blacklist = blacklist;
    }
}

