/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.servlet.jakarta;

import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.core.servlet.MagicRequestContextHolder;
import org.ssssssss.magicapi.servlet.jakarta.MagicJakartaCorsFilter;
import org.ssssssss.magicapi.servlet.jakarta.MagicJakartaHttpServletRequest;
import org.ssssssss.magicapi.servlet.jakarta.MagicJakartaHttpServletResponse;
import org.ssssssss.magicapi.servlet.jakarta.MagicJakartaRequestContextHolder;
import org.ssssssss.magicapi.servlet.jakarta.MagicJakartaResponseExtension;
import org.ssssssss.magicapi.servlet.jakarta.MagicJakartaWebRequestInterceptor;
import org.ssssssss.magicapi.servlet.jakarta.WebIPLimitRequestInterceptor;

@Configuration
public class MagicJakartaServletConfiguration
implements WebMvcConfigurer {
    private final MagicAPIProperties properties;
    private final MagicJakartaCorsFilter magicCorsFilter = new MagicJakartaCorsFilter();
    private final ObjectProvider<MagicJakartaWebRequestInterceptor> magicWebRequestInterceptorProvider;
    private final WebIPLimitRequestInterceptor webIPLimitRequestInterceptor;

    public MagicJakartaServletConfiguration(MagicAPIProperties properties, ObjectProvider<MagicJakartaWebRequestInterceptor> magicWebRequestInterceptorProvider, WebIPLimitRequestInterceptor webIPLimitRequestInterceptorProvider) {
        this.properties = properties;
        this.magicWebRequestInterceptorProvider = magicWebRequestInterceptorProvider;
        this.webIPLimitRequestInterceptor = webIPLimitRequestInterceptorProvider;
    }

    @Bean
    public MagicRequestContextHolder magicRequestContextHolder(MultipartResolver multipartResolver) {
        return new MagicJakartaRequestContextHolder(multipartResolver);
    }

    @Bean
    public MagicJakartaWebRequestInterceptor magicWebRequestInterceptor(AuthorizationInterceptor authorizationInterceptor) {
        return new MagicJakartaWebRequestInterceptor(this.properties.isSupportCrossDomain() ? this.magicCorsFilter : null, authorizationInterceptor);
    }

    @Bean
    public MagicJakartaResponseExtension magicJakartaResponseExtension() {
        return new MagicJakartaResponseExtension();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(0, new MagicJakartaHttpServletRequest.ArgumentsResolver());
        resolvers.add(0, new MagicJakartaHttpServletResponse.ArgumentsResolver());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.magicWebRequestInterceptorProvider.getObject()).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)this.webIPLimitRequestInterceptor).addPathPatterns(new String[]{this.properties.getWeb() + "/**"});
    }

    @Bean
    @ConditionalOnProperty(prefix="magic-api", value={"support-cross-domain"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<MagicJakartaCorsFilter> magicCorsFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)this.magicCorsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("Magic Cors Filter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }
}

