/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie;

import io.github.linpeilie.AbstractCachedConverterFactory;
import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import io.github.linpeilie.annotations.MapperConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import org.mapstruct.factory.Mappers;

public class DefaultConverterFactory
extends AbstractCachedConverterFactory {
    private String basePackage;

    public DefaultConverterFactory() {
        this("");
    }

    public DefaultConverterFactory(String basePackage) {
        this.basePackage = basePackage;
        if (basePackage == null || basePackage.isEmpty()) {
            this.loadBasePackage();
        }
    }

    private void loadBasePackage() {
        Enumeration<URL> resources;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            resources = classLoader.getResources("");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            this.loadClasses(null, url.getPath(), classes, classLoader);
        }
        classes.stream().filter(clazz -> clazz.isAnnotationPresent(MapperConfig.class)).findFirst().ifPresent(clazz -> {
            MapperConfig mapperConfig = clazz.getAnnotation(MapperConfig.class);
            this.basePackage = mapperConfig.mapperPackage();
        });
    }

    private void loadClasses(String root, String path, List<Class<?>> classes, ClassLoader classLoader) {
        File file = new File(path);
        if (root == null) {
            root = file.getPath();
        }
        if (file.isFile()) {
            if (!file.getName().endsWith(".class")) {
                return;
            }
            try {
                String classPath = file.getPath();
                String className = classPath.substring(root.length() + 1, classPath.length() - 6).replaceAll(Matcher.quoteReplacement(File.separator), ".");
                classes.add(classLoader.loadClass(className));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.loadClasses(root, f.getPath(), classes, classLoader);
            }
        }
    }

    private String getMapperClassName(Class<?> source, Class<?> target) {
        return source.getSimpleName() + "To" + target.getSimpleName() + "Mapper";
    }

    private String getMapMapperClassName(Class<?> source) {
        return "MapTo" + source.getSimpleName() + "Mapper";
    }

    private String getMapperPackage(Class<?> sourceType) {
        return this.basePackage != null && !this.basePackage.isEmpty() ? this.basePackage : sourceType.getPackage().getName();
    }

    @Override
    public <S, T> BaseMapper<S, T> findMapper(Class<S> sourceType, Class<T> targetType) {
        String mapperClassName = this.getMapperClassName(sourceType, targetType);
        try {
            Class<?> mapperClass = Class.forName(this.getMapperPackage(sourceType) + "." + mapperClassName);
            return (BaseMapper)Mappers.getMapper(mapperClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    protected <S> BaseMapMapper findMapMapper(Class<?> source) {
        String mapperClassName = this.getMapMapperClassName(source);
        try {
            Class<?> mapperClass = Class.forName(this.getMapperPackage(source) + "." + mapperClassName);
            return (BaseMapMapper)Mappers.getMapper(mapperClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

